#include <math.h>
#include <stdio.h>
#include <float.h>
#include "mtrand.h"
#define exponentiale M_E
#define pi M_PI
double max(double a, double b){
return a > b ? a : b;}
double root(double n,double x);

double root_0(double n,double x);

double root_1(double n,double x);

double cot(double x);

double cot_0(double x);

double arccot(double x);

double arccot_0(double x);

double coth(double x);

double coth_0(double x);

double csc(double x);

double csc_0(double x);

double arccsc(double x);

double arccsc_0(double x);

double csch(double x);

double csch_0(double x);

double sec(double x);

double sec_0(double x);

double arcsec(double x);

double arcsec_0(double x);

double sech(double x);

double sech_0(double x);

void res_function_(double *time_ptr, double *dynamicVars, double *yprime, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar);

void alg_deriv_func_(double *alg_yp, double *dynamicVars, double *yp, double *time_ptr, double *constants, double *alg_derivs_res);

void alg_res_func_(double *alg_vals, double *dynamicVars, double *time_ptr, double *constants, double *residual);

void dres_dc_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dcdot_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void ddaskr_jac_(double *time_ptr, double *dynamicVars, double *yprime, double *pd, double *cj_ptr, double *constants, int *intpar);

void dres_dkrbEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkruEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkrbNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkruNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkdSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmdSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkRasGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmRasGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkRasToRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmRasToRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkpRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmpRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkpBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmpBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkdMek_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmdMek_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkpMekCytoplasmic_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmpMekCytoplasmic_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkdErk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmdErk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkpP90Rsk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmpP90Rsk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkPI3K_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmPI3K_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkPI3KRas_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmPI3KRas_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkdRaf1ByAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmRaf1ByAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkC3GNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmC3GNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkC3G_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmC3G_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkRapGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmRapGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkRap1ToBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmRap1ToBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkdRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmdRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dkdBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dKmdBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void sens_rhs_(double *time_ptr, double *sens_y, double *sens_yp, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar);

void res_function_logdv_(double *time_ptr, double *log_dv, double *log_yp, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar);

void root_func_logdv_(int *neq_ptr, double *time_ptr, double *log_dv, double *log_yp, int *nrt_ptr, double *root_devs, double *constants, int *ipar);

void sens_rhs_logdv_(double *time_ptr, double *sens_y_log, double *sens_yp_log, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar);

void integrate_stochatic_tidbit_(unsigned long* seed_ptr, int* reseed, double* time_ptr, int* dv, double* cv, double* rmsd_ptr, double* stop_time_ptr, double* trajectory);

void root_func_(int *neq_ptr, double *time_ptr, double *dynamicVars, double *yprime, int *nrt_ptr, double *root_devs, double *constants, int *ipar);

double root(double n,double x){
return pow(x, 1.0/n);
}

double root_0(double n,double x){
return -(log(x)*pow(x, 1.0/n)*1.0/pow(n, 2.0));
}

double root_1(double n,double x){
return pow(x, 1.0/n - 1.0)/n;
}

double cot(double x){
return 1.0/tan(x);
}

double cot_0(double x){
return -(1.0/(pow(cos(x), 2.0)*pow(tan(x), 2.0)));
}

double arccot(double x){
return atan(1.0/x);
}

double arccot_0(double x){
return -(1.0/pow(x, 2.0)/(pow(1.0/x, 2.0) + 1.0));
}

double coth(double x){
return 1.0/tanh(x);
}

double coth_0(double x){
return -(1.0/(pow(cosh(x), 2.0)*pow(tanh(x), 2.0)));
}

double csc(double x){
return 1.0/sin(x);
}

double csc_0(double x){
return -(cos(x)/pow(sin(x), 2.0));
}

double arccsc(double x){
return asin(1.0/x);
}

double arccsc_0(double x){
return -(1.0/pow(x, 2.0)/sqrt(1.0 - pow(1.0/x, 2.0)));
}

double csch(double x){
return 1.0/sinh(x);
}

double csch_0(double x){
return -(cosh(x)/pow(sinh(x), 2.0));
}

double sec(double x){
return 1.0/cos(x);
}

double sec_0(double x){
return sin(x)/pow(cos(x), 2.0);
}

double arcsec(double x){
return acos(1.0/x);
}

double arcsec_0(double x){
return -(1.0/pow(x, 2.0)/sqrt(1.0 - pow(1.0/x, 2.0)));
}

double sech(double x){
return 1.0/cosh(x);
}

double sech_0(double x){
return -(sinh(x)/pow(cosh(x), 2.0));
}

void res_function_(double *time_ptr, double *dynamicVars, double *yprime, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


residual[0] = kruEGF*boundEGFReceptor - krbEGF*EGF*freeEGFReceptor - yprime[0];
residual[1] = kruNGF*boundNGFReceptor - krbNGF*NGF*freeNGFReceptor - yprime[1];
residual[2] = kruEGF*boundEGFReceptor - krbEGF*EGF*freeEGFReceptor - yprime[2];
residual[3] = krbEGF*EGF*freeEGFReceptor - kruEGF*boundEGFReceptor - yprime[3];
residual[4] = kruNGF*boundNGFReceptor - krbNGF*NGF*freeNGFReceptor - yprime[4];
residual[5] = krbNGF*NGF*freeNGFReceptor - kruNGF*boundNGFReceptor - yprime[5];
residual[6] = kdSos*P90RskActive*SosActive/(SosActive + KmdSos) - kEGF*boundEGFReceptor*SosInactive/(SosInactive + KmEGF) - kNGF*boundNGFReceptor*SosInactive/(SosInactive + KmNGF) - yprime[6];
residual[7] = kEGF*boundEGFReceptor*SosInactive/(SosInactive + KmEGF) + kNGF*boundNGFReceptor*SosInactive/(SosInactive + KmNGF) - kdSos*P90RskActive*SosActive/(SosActive + KmdSos) - yprime[7];
residual[8] = -(kpP90Rsk*ErkActive*P90RskInactive/(P90RskInactive + KmpP90Rsk)) - yprime[8];
residual[9] = kpP90Rsk*ErkActive*P90RskInactive/(P90RskInactive + KmpP90Rsk) - yprime[9];
residual[10] = kRasGap*RasGapActive*RasActive/(RasActive + KmRasGap) - kSos*SosActive*RasInactive/(RasInactive + KmSos) - yprime[10];
residual[11] = kSos*SosActive*RasInactive/(RasInactive + KmSos) - kRasGap*RasGapActive*RasActive/(RasActive + KmRasGap) - yprime[11];
residual[12] = -yprime[12];
residual[13] = kdRaf1*Raf1PPtase*Raf1Active/(Raf1Active + KmdRaf1) + kdRaf1ByAkt*AktActive*Raf1Active/(Raf1Active + KmRaf1ByAkt) - kRasToRaf1*RasActive*Raf1Inactive/(Raf1Inactive + KmRasToRaf1) - yprime[13];
residual[14] = kRasToRaf1*RasActive*Raf1Inactive/(Raf1Inactive + KmRasToRaf1) - kdRaf1*Raf1PPtase*Raf1Active/(Raf1Active + KmdRaf1) - kdRaf1ByAkt*AktActive*Raf1Active/(Raf1Active + KmRaf1ByAkt) - yprime[14];
residual[15] = kdBRaf*Raf1PPtase*BRafActive/(BRafActive + KmdBRaf) - kRap1ToBRaf*Rap1Active*BRafInactive/(BRafInactive + KmRap1ToBRaf) - yprime[15];
residual[16] = kRap1ToBRaf*Rap1Active*BRafInactive/(BRafInactive + KmRap1ToBRaf) - kdBRaf*Raf1PPtase*BRafActive/(BRafActive + KmdBRaf) - yprime[16];
residual[17] = kdMek*PP2AActive*MekActive/(MekActive + KmdMek) - kpRaf1*Raf1Active*MekInactive/(MekInactive + KmpRaf1) - kpBRaf*BRafActive*MekInactive/(MekInactive + KmpBRaf) - yprime[17];
residual[18] = kpRaf1*Raf1Active*MekInactive/(MekInactive + KmpRaf1) + kpBRaf*BRafActive*MekInactive/(MekInactive + KmpBRaf) - kdMek*PP2AActive*MekActive/(MekActive + KmdMek) - yprime[18];
residual[19] = kdErk*PP2AActive*ErkActive/(ErkActive + KmdErk) - kpMekCytoplasmic*MekActive*ErkInactive/(ErkInactive + KmpMekCytoplasmic) - yprime[19];
residual[20] = kpMekCytoplasmic*MekActive*ErkInactive/(ErkInactive + KmpMekCytoplasmic) - kdErk*PP2AActive*ErkActive/(ErkActive + KmdErk) - yprime[20];
residual[21] = -(kPI3K*boundEGFReceptor*PI3KInactive/(PI3KInactive + KmPI3K)) - kPI3KRas*RasActive*PI3KInactive/(PI3KInactive + KmPI3KRas) - yprime[21];
residual[22] = kPI3K*boundEGFReceptor*PI3KInactive/(PI3KInactive + KmPI3K) + kPI3KRas*RasActive*PI3KInactive/(PI3KInactive + KmPI3KRas) - yprime[22];
residual[23] = -(kAkt*PI3KActive*AktInactive/(AktInactive + KmAkt)) - yprime[23];
residual[24] = kAkt*PI3KActive*AktInactive/(AktInactive + KmAkt) - yprime[24];
residual[25] = -(kC3GNGF*boundNGFReceptor*C3GInactive/(C3GInactive + KmC3GNGF)) - yprime[25];
residual[26] = kC3GNGF*boundNGFReceptor*C3GInactive/(C3GInactive + KmC3GNGF) - yprime[26];
residual[27] = kRapGap*RapGapActive*Rap1Active/(Rap1Active + KmRapGap) - kC3G*C3GActive*Rap1Inactive/(Rap1Inactive + KmC3G) - yprime[27];
residual[28] = kC3G*C3GActive*Rap1Inactive/(Rap1Inactive + KmC3G) - kRapGap*RapGapActive*Rap1Active/(Rap1Active + KmRapGap) - yprime[28];
residual[29] = -yprime[29];
residual[30] = -yprime[30];
residual[31] = -yprime[31];
}

void alg_deriv_func_(double *alg_yp, double *dynamicVars, double *yp, double *time_ptr, double *constants, double *alg_derivs_res){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


}

void alg_res_func_(double *alg_vals, double *dynamicVars, double *time_ptr, double *constants, double *residual){
double time = *time_ptr;


double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


}

void dres_dc_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[0] = -(krbEGF*freeEGFReceptor);
pd[64] = -(krbEGF*EGF);
pd[96] = kruEGF;
pd[33] = -(krbNGF*freeNGFReceptor);
pd[129] = -(krbNGF*NGF);
pd[161] = kruNGF;
pd[2] = -(krbEGF*freeEGFReceptor);
pd[66] = -(krbEGF*EGF);
pd[98] = kruEGF;
pd[3] = krbEGF*freeEGFReceptor;
pd[67] = krbEGF*EGF;
pd[99] = -kruEGF;
pd[36] = -(krbNGF*freeNGFReceptor);
pd[132] = -(krbNGF*NGF);
pd[164] = kruNGF;
pd[37] = krbNGF*freeNGFReceptor;
pd[133] = krbNGF*NGF;
pd[165] = -kruNGF;
pd[102] = -(kEGF*SosInactive/(SosInactive + KmEGF));
pd[166] = -(kNGF*SosInactive/(SosInactive + KmNGF));
pd[198] = kEGF*boundEGFReceptor*SosInactive/pow(SosInactive + KmEGF, 2.0) + kNGF*boundNGFReceptor*SosInactive/pow(SosInactive + KmNGF, 2.0) - kEGF*boundEGFReceptor/(SosInactive + KmEGF) - kNGF*boundNGFReceptor/(SosInactive + KmNGF);
pd[230] = kdSos*P90RskActive/(SosActive + KmdSos) - kdSos*P90RskActive*SosActive/pow(SosActive + KmdSos, 2.0);
pd[294] = kdSos*SosActive/(SosActive + KmdSos);
pd[103] = kEGF*SosInactive/(SosInactive + KmEGF);
pd[167] = kNGF*SosInactive/(SosInactive + KmNGF);
pd[199] = kEGF*boundEGFReceptor/(SosInactive + KmEGF) + kNGF*boundNGFReceptor/(SosInactive + KmNGF) - kEGF*boundEGFReceptor*SosInactive/pow(SosInactive + KmEGF, 2.0) - kNGF*boundNGFReceptor*SosInactive/pow(SosInactive + KmNGF, 2.0);
pd[231] = kdSos*P90RskActive*SosActive/pow(SosActive + KmdSos, 2.0) - kdSos*P90RskActive/(SosActive + KmdSos);
pd[295] = -(kdSos*SosActive/(SosActive + KmdSos));
pd[264] = -(kpP90Rsk*ErkActive/(P90RskInactive + KmpP90Rsk) - kpP90Rsk*ErkActive*P90RskInactive/pow(P90RskInactive + KmpP90Rsk, 2.0));
pd[648] = -(kpP90Rsk*P90RskInactive/(P90RskInactive + KmpP90Rsk));
pd[265] = kpP90Rsk*ErkActive/(P90RskInactive + KmpP90Rsk) - kpP90Rsk*ErkActive*P90RskInactive/pow(P90RskInactive + KmpP90Rsk, 2.0);
pd[649] = kpP90Rsk*P90RskInactive/(P90RskInactive + KmpP90Rsk);
pd[234] = -(kSos*RasInactive/(RasInactive + KmSos));
pd[330] = kSos*SosActive*RasInactive/pow(RasInactive + KmSos, 2.0) - kSos*SosActive/(RasInactive + KmSos);
pd[362] = kRasGap*RasGapActive/(RasActive + KmRasGap) - kRasGap*RasGapActive*RasActive/pow(RasActive + KmRasGap, 2.0);
pd[394] = kRasGap*RasActive/(RasActive + KmRasGap);
pd[235] = kSos*RasInactive/(RasInactive + KmSos);
pd[331] = kSos*SosActive/(RasInactive + KmSos) - kSos*SosActive*RasInactive/pow(RasInactive + KmSos, 2.0);
pd[363] = kRasGap*RasGapActive*RasActive/pow(RasActive + KmRasGap, 2.0) - kRasGap*RasGapActive/(RasActive + KmRasGap);
pd[395] = -(kRasGap*RasActive/(RasActive + KmRasGap));
pd[365] = -(kRasToRaf1*Raf1Inactive/(Raf1Inactive + KmRasToRaf1));
pd[429] = kRasToRaf1*RasActive*Raf1Inactive/pow(Raf1Inactive + KmRasToRaf1, 2.0) - kRasToRaf1*RasActive/(Raf1Inactive + KmRasToRaf1);
pd[461] = kdRaf1*Raf1PPtase/(Raf1Active + KmdRaf1) + kdRaf1ByAkt*AktActive/(Raf1Active + KmRaf1ByAkt) - kdRaf1*Raf1PPtase*Raf1Active/pow(Raf1Active + KmdRaf1, 2.0) - kdRaf1ByAkt*AktActive*Raf1Active/pow(Raf1Active + KmRaf1ByAkt, 2.0);
pd[781] = kdRaf1ByAkt*Raf1Active/(Raf1Active + KmRaf1ByAkt);
pd[1005] = kdRaf1*Raf1Active/(Raf1Active + KmdRaf1);
pd[366] = kRasToRaf1*Raf1Inactive/(Raf1Inactive + KmRasToRaf1);
pd[430] = kRasToRaf1*RasActive/(Raf1Inactive + KmRasToRaf1) - kRasToRaf1*RasActive*Raf1Inactive/pow(Raf1Inactive + KmRasToRaf1, 2.0);
pd[462] = kdRaf1*Raf1PPtase*Raf1Active/pow(Raf1Active + KmdRaf1, 2.0) + kdRaf1ByAkt*AktActive*Raf1Active/pow(Raf1Active + KmRaf1ByAkt, 2.0) - kdRaf1*Raf1PPtase/(Raf1Active + KmdRaf1) - kdRaf1ByAkt*AktActive/(Raf1Active + KmRaf1ByAkt);
pd[782] = -(kdRaf1ByAkt*Raf1Active/(Raf1Active + KmRaf1ByAkt));
pd[1006] = -(kdRaf1*Raf1Active/(Raf1Active + KmdRaf1));
pd[495] = kRap1ToBRaf*Rap1Active*BRafInactive/pow(BRafInactive + KmRap1ToBRaf, 2.0) - kRap1ToBRaf*Rap1Active/(BRafInactive + KmRap1ToBRaf);
pd[527] = kdBRaf*Raf1PPtase/(BRafActive + KmdBRaf) - kdBRaf*Raf1PPtase*BRafActive/pow(BRafActive + KmdBRaf, 2.0);
pd[911] = -(kRap1ToBRaf*BRafInactive/(BRafInactive + KmRap1ToBRaf));
pd[1007] = kdBRaf*BRafActive/(BRafActive + KmdBRaf);
pd[496] = kRap1ToBRaf*Rap1Active/(BRafInactive + KmRap1ToBRaf) - kRap1ToBRaf*Rap1Active*BRafInactive/pow(BRafInactive + KmRap1ToBRaf, 2.0);
pd[528] = kdBRaf*Raf1PPtase*BRafActive/pow(BRafActive + KmdBRaf, 2.0) - kdBRaf*Raf1PPtase/(BRafActive + KmdBRaf);
pd[912] = kRap1ToBRaf*BRafInactive/(BRafInactive + KmRap1ToBRaf);
pd[1008] = -(kdBRaf*BRafActive/(BRafActive + KmdBRaf));
pd[465] = -(kpRaf1*MekInactive/(MekInactive + KmpRaf1));
pd[529] = -(kpBRaf*MekInactive/(MekInactive + KmpBRaf));
pd[561] = kpRaf1*Raf1Active*MekInactive/pow(MekInactive + KmpRaf1, 2.0) + kpBRaf*BRafActive*MekInactive/pow(MekInactive + KmpBRaf, 2.0) - kpRaf1*Raf1Active/(MekInactive + KmpRaf1) - kpBRaf*BRafActive/(MekInactive + KmpBRaf);
pd[593] = kdMek*PP2AActive/(MekActive + KmdMek) - kdMek*PP2AActive*MekActive/pow(MekActive + KmdMek, 2.0);
pd[977] = kdMek*MekActive/(MekActive + KmdMek);
pd[466] = kpRaf1*MekInactive/(MekInactive + KmpRaf1);
pd[530] = kpBRaf*MekInactive/(MekInactive + KmpBRaf);
pd[562] = kpRaf1*Raf1Active/(MekInactive + KmpRaf1) + kpBRaf*BRafActive/(MekInactive + KmpBRaf) - kpRaf1*Raf1Active*MekInactive/pow(MekInactive + KmpRaf1, 2.0) - kpBRaf*BRafActive*MekInactive/pow(MekInactive + KmpBRaf, 2.0);
pd[594] = kdMek*PP2AActive*MekActive/pow(MekActive + KmdMek, 2.0) - kdMek*PP2AActive/(MekActive + KmdMek);
pd[978] = -(kdMek*MekActive/(MekActive + KmdMek));
pd[595] = -(kpMekCytoplasmic*ErkInactive/(ErkInactive + KmpMekCytoplasmic));
pd[627] = kpMekCytoplasmic*MekActive*ErkInactive/pow(ErkInactive + KmpMekCytoplasmic, 2.0) - kpMekCytoplasmic*MekActive/(ErkInactive + KmpMekCytoplasmic);
pd[659] = kdErk*PP2AActive/(ErkActive + KmdErk) - kdErk*PP2AActive*ErkActive/pow(ErkActive + KmdErk, 2.0);
pd[979] = kdErk*ErkActive/(ErkActive + KmdErk);
pd[596] = kpMekCytoplasmic*ErkInactive/(ErkInactive + KmpMekCytoplasmic);
pd[628] = kpMekCytoplasmic*MekActive/(ErkInactive + KmpMekCytoplasmic) - kpMekCytoplasmic*MekActive*ErkInactive/pow(ErkInactive + KmpMekCytoplasmic, 2.0);
pd[660] = kdErk*PP2AActive*ErkActive/pow(ErkActive + KmdErk, 2.0) - kdErk*PP2AActive/(ErkActive + KmdErk);
pd[980] = -(kdErk*ErkActive/(ErkActive + KmdErk));
pd[117] = -(kPI3K*PI3KInactive/(PI3KInactive + KmPI3K));
pd[373] = -(kPI3KRas*PI3KInactive/(PI3KInactive + KmPI3KRas));
pd[693] = kPI3KRas*RasActive*PI3KInactive/pow(PI3KInactive + KmPI3KRas, 2.0) + kPI3K*boundEGFReceptor*PI3KInactive/pow(PI3KInactive + KmPI3K, 2.0) - kPI3K*boundEGFReceptor/(PI3KInactive + KmPI3K) - kPI3KRas*RasActive/(PI3KInactive + KmPI3KRas);
pd[118] = kPI3K*PI3KInactive/(PI3KInactive + KmPI3K);
pd[374] = kPI3KRas*PI3KInactive/(PI3KInactive + KmPI3KRas);
pd[694] = kPI3K*boundEGFReceptor/(PI3KInactive + KmPI3K) + kPI3KRas*RasActive/(PI3KInactive + KmPI3KRas) - kPI3K*boundEGFReceptor*PI3KInactive/pow(PI3KInactive + KmPI3K, 2.0) - kPI3KRas*RasActive*PI3KInactive/pow(PI3KInactive + KmPI3KRas, 2.0);
pd[727] = -(kAkt*AktInactive/(AktInactive + KmAkt));
pd[759] = -(kAkt*PI3KActive/(AktInactive + KmAkt) - kAkt*PI3KActive*AktInactive/pow(AktInactive + KmAkt, 2.0));
pd[728] = kAkt*AktInactive/(AktInactive + KmAkt);
pd[760] = kAkt*PI3KActive/(AktInactive + KmAkt) - kAkt*PI3KActive*AktInactive/pow(AktInactive + KmAkt, 2.0);
pd[185] = -(kC3GNGF*C3GInactive/(C3GInactive + KmC3GNGF));
pd[825] = -(kC3GNGF*boundNGFReceptor/(C3GInactive + KmC3GNGF) - kC3GNGF*boundNGFReceptor*C3GInactive/pow(C3GInactive + KmC3GNGF, 2.0));
pd[186] = kC3GNGF*C3GInactive/(C3GInactive + KmC3GNGF);
pd[826] = kC3GNGF*boundNGFReceptor/(C3GInactive + KmC3GNGF) - kC3GNGF*boundNGFReceptor*C3GInactive/pow(C3GInactive + KmC3GNGF, 2.0);
pd[859] = -(kC3G*Rap1Inactive/(Rap1Inactive + KmC3G));
pd[891] = kC3G*C3GActive*Rap1Inactive/pow(Rap1Inactive + KmC3G, 2.0) - kC3G*C3GActive/(Rap1Inactive + KmC3G);
pd[923] = kRapGap*RapGapActive/(Rap1Active + KmRapGap) - kRapGap*RapGapActive*Rap1Active/pow(Rap1Active + KmRapGap, 2.0);
pd[955] = kRapGap*Rap1Active/(Rap1Active + KmRapGap);
pd[860] = kC3G*Rap1Inactive/(Rap1Inactive + KmC3G);
pd[892] = kC3G*C3GActive/(Rap1Inactive + KmC3G) - kC3G*C3GActive*Rap1Inactive/pow(Rap1Inactive + KmC3G, 2.0);
pd[924] = kRapGap*RapGapActive*Rap1Active/pow(Rap1Active + KmRapGap, 2.0) - kRapGap*RapGapActive/(Rap1Active + KmRapGap);
pd[956] = -(kRapGap*Rap1Active/(Rap1Active + KmRapGap));
}

void dres_dcdot_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[0] = -1;
pd[33] = -1;
pd[66] = -1;
pd[99] = -1;
pd[132] = -1;
pd[165] = -1;
pd[198] = -1;
pd[231] = -1;
pd[264] = -1;
pd[297] = -1;
pd[330] = -1;
pd[363] = -1;
pd[396] = -1;
pd[429] = -1;
pd[462] = -1;
pd[495] = -1;
pd[528] = -1;
pd[561] = -1;
pd[594] = -1;
pd[627] = -1;
pd[660] = -1;
pd[693] = -1;
pd[726] = -1;
pd[759] = -1;
pd[792] = -1;
pd[825] = -1;
pd[858] = -1;
pd[891] = -1;
pd[924] = -1;
pd[957] = -1;
pd[990] = -1;
pd[1023] = -1;
}

void ddaskr_jac_(double *time_ptr, double *dynamicVars, double *yprime, double *pd, double *cj_ptr, double *constants, int *intpar){
double cj = *cj_ptr;

dres_dc_function_(time_ptr, dynamicVars, yprime, constants, pd);

double dres_dcdot[32*32] = {0};
dres_dcdot_function_(time_ptr, dynamicVars, yprime, constants, dres_dcdot);

int ii;
for(ii=0; ii < 1024; ii++){
  pd[ii] += cj*dres_dcdot[ii];}
}

void dres_dkrbEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[0] = -(EGF*freeEGFReceptor);
pd[2] = -(EGF*freeEGFReceptor);
pd[3] = EGF*freeEGFReceptor;
}

void dres_dkruEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[0] = boundEGFReceptor;
pd[2] = boundEGFReceptor;
pd[3] = -boundEGFReceptor;
}

void dres_dkrbNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[1] = -(NGF*freeNGFReceptor);
pd[4] = -(NGF*freeNGFReceptor);
pd[5] = NGF*freeNGFReceptor;
}

void dres_dkruNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[1] = boundNGFReceptor;
pd[4] = boundNGFReceptor;
pd[5] = -boundNGFReceptor;
}

void dres_dkEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[6] = -(boundEGFReceptor*SosInactive/(SosInactive + KmEGF));
pd[7] = boundEGFReceptor*SosInactive/(SosInactive + KmEGF);
}

void dres_dKmEGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[6] = kEGF*boundEGFReceptor*SosInactive/pow(SosInactive + KmEGF, 2.0);
pd[7] = -(kEGF*boundEGFReceptor*SosInactive/pow(SosInactive + KmEGF, 2.0));
}

void dres_dkNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[6] = -(boundNGFReceptor*SosInactive/(SosInactive + KmNGF));
pd[7] = boundNGFReceptor*SosInactive/(SosInactive + KmNGF);
}

void dres_dKmNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[6] = kNGF*boundNGFReceptor*SosInactive/pow(SosInactive + KmNGF, 2.0);
pd[7] = -(kNGF*boundNGFReceptor*SosInactive/pow(SosInactive + KmNGF, 2.0));
}

void dres_dkdSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[6] = P90RskActive*SosActive/(SosActive + KmdSos);
pd[7] = -(P90RskActive*SosActive/(SosActive + KmdSos));
}

void dres_dKmdSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[6] = -(kdSos*P90RskActive*SosActive/pow(SosActive + KmdSos, 2.0));
pd[7] = kdSos*P90RskActive*SosActive/pow(SosActive + KmdSos, 2.0);
}

void dres_dkSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[10] = -(SosActive*RasInactive/(RasInactive + KmSos));
pd[11] = SosActive*RasInactive/(RasInactive + KmSos);
}

void dres_dKmSos_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[10] = kSos*SosActive*RasInactive/pow(RasInactive + KmSos, 2.0);
pd[11] = -(kSos*SosActive*RasInactive/pow(RasInactive + KmSos, 2.0));
}

void dres_dkRasGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[10] = RasGapActive*RasActive/(RasActive + KmRasGap);
pd[11] = -(RasGapActive*RasActive/(RasActive + KmRasGap));
}

void dres_dKmRasGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[10] = -(kRasGap*RasGapActive*RasActive/pow(RasActive + KmRasGap, 2.0));
pd[11] = kRasGap*RasGapActive*RasActive/pow(RasActive + KmRasGap, 2.0);
}

void dres_dkRasToRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[13] = -(RasActive*Raf1Inactive/(Raf1Inactive + KmRasToRaf1));
pd[14] = RasActive*Raf1Inactive/(Raf1Inactive + KmRasToRaf1);
}

void dres_dKmRasToRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[13] = kRasToRaf1*RasActive*Raf1Inactive/pow(Raf1Inactive + KmRasToRaf1, 2.0);
pd[14] = -(kRasToRaf1*RasActive*Raf1Inactive/pow(Raf1Inactive + KmRasToRaf1, 2.0));
}

void dres_dkpRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[17] = -(Raf1Active*MekInactive/(MekInactive + KmpRaf1));
pd[18] = Raf1Active*MekInactive/(MekInactive + KmpRaf1);
}

void dres_dKmpRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[17] = kpRaf1*Raf1Active*MekInactive/pow(MekInactive + KmpRaf1, 2.0);
pd[18] = -(kpRaf1*Raf1Active*MekInactive/pow(MekInactive + KmpRaf1, 2.0));
}

void dres_dkpBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[17] = -(BRafActive*MekInactive/(MekInactive + KmpBRaf));
pd[18] = BRafActive*MekInactive/(MekInactive + KmpBRaf);
}

void dres_dKmpBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[17] = kpBRaf*BRafActive*MekInactive/pow(MekInactive + KmpBRaf, 2.0);
pd[18] = -(kpBRaf*BRafActive*MekInactive/pow(MekInactive + KmpBRaf, 2.0));
}

void dres_dkdMek_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[17] = PP2AActive*MekActive/(MekActive + KmdMek);
pd[18] = -(PP2AActive*MekActive/(MekActive + KmdMek));
}

void dres_dKmdMek_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[17] = -(kdMek*PP2AActive*MekActive/pow(MekActive + KmdMek, 2.0));
pd[18] = kdMek*PP2AActive*MekActive/pow(MekActive + KmdMek, 2.0);
}

void dres_dkpMekCytoplasmic_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[19] = -(MekActive*ErkInactive/(ErkInactive + KmpMekCytoplasmic));
pd[20] = MekActive*ErkInactive/(ErkInactive + KmpMekCytoplasmic);
}

void dres_dKmpMekCytoplasmic_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[19] = kpMekCytoplasmic*MekActive*ErkInactive/pow(ErkInactive + KmpMekCytoplasmic, 2.0);
pd[20] = -(kpMekCytoplasmic*MekActive*ErkInactive/pow(ErkInactive + KmpMekCytoplasmic, 2.0));
}

void dres_dkdErk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[19] = PP2AActive*ErkActive/(ErkActive + KmdErk);
pd[20] = -(PP2AActive*ErkActive/(ErkActive + KmdErk));
}

void dres_dKmdErk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[19] = -(kdErk*PP2AActive*ErkActive/pow(ErkActive + KmdErk, 2.0));
pd[20] = kdErk*PP2AActive*ErkActive/pow(ErkActive + KmdErk, 2.0);
}

void dres_dkpP90Rsk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[8] = -(ErkActive*P90RskInactive/(P90RskInactive + KmpP90Rsk));
pd[9] = ErkActive*P90RskInactive/(P90RskInactive + KmpP90Rsk);
}

void dres_dKmpP90Rsk_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[8] = kpP90Rsk*ErkActive*P90RskInactive/pow(P90RskInactive + KmpP90Rsk, 2.0);
pd[9] = -(kpP90Rsk*ErkActive*P90RskInactive/pow(P90RskInactive + KmpP90Rsk, 2.0));
}

void dres_dkPI3K_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[21] = -(boundEGFReceptor*PI3KInactive/(PI3KInactive + KmPI3K));
pd[22] = boundEGFReceptor*PI3KInactive/(PI3KInactive + KmPI3K);
}

void dres_dKmPI3K_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[21] = kPI3K*boundEGFReceptor*PI3KInactive/pow(PI3KInactive + KmPI3K, 2.0);
pd[22] = -(kPI3K*boundEGFReceptor*PI3KInactive/pow(PI3KInactive + KmPI3K, 2.0));
}

void dres_dkPI3KRas_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[21] = -(RasActive*PI3KInactive/(PI3KInactive + KmPI3KRas));
pd[22] = RasActive*PI3KInactive/(PI3KInactive + KmPI3KRas);
}

void dres_dKmPI3KRas_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[21] = kPI3KRas*RasActive*PI3KInactive/pow(PI3KInactive + KmPI3KRas, 2.0);
pd[22] = -(kPI3KRas*RasActive*PI3KInactive/pow(PI3KInactive + KmPI3KRas, 2.0));
}

void dres_dkAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[23] = -(PI3KActive*AktInactive/(AktInactive + KmAkt));
pd[24] = PI3KActive*AktInactive/(AktInactive + KmAkt);
}

void dres_dKmAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[23] = kAkt*PI3KActive*AktInactive/pow(AktInactive + KmAkt, 2.0);
pd[24] = -(kAkt*PI3KActive*AktInactive/pow(AktInactive + KmAkt, 2.0));
}

void dres_dkdRaf1ByAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[13] = AktActive*Raf1Active/(Raf1Active + KmRaf1ByAkt);
pd[14] = -(AktActive*Raf1Active/(Raf1Active + KmRaf1ByAkt));
}

void dres_dKmRaf1ByAkt_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[13] = -(kdRaf1ByAkt*AktActive*Raf1Active/pow(Raf1Active + KmRaf1ByAkt, 2.0));
pd[14] = kdRaf1ByAkt*AktActive*Raf1Active/pow(Raf1Active + KmRaf1ByAkt, 2.0);
}

void dres_dkC3GNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[25] = -(boundNGFReceptor*C3GInactive/(C3GInactive + KmC3GNGF));
pd[26] = boundNGFReceptor*C3GInactive/(C3GInactive + KmC3GNGF);
}

void dres_dKmC3GNGF_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[25] = kC3GNGF*boundNGFReceptor*C3GInactive/pow(C3GInactive + KmC3GNGF, 2.0);
pd[26] = -(kC3GNGF*boundNGFReceptor*C3GInactive/pow(C3GInactive + KmC3GNGF, 2.0));
}

void dres_dkC3G_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[27] = -(C3GActive*Rap1Inactive/(Rap1Inactive + KmC3G));
pd[28] = C3GActive*Rap1Inactive/(Rap1Inactive + KmC3G);
}

void dres_dKmC3G_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[27] = kC3G*C3GActive*Rap1Inactive/pow(Rap1Inactive + KmC3G, 2.0);
pd[28] = -(kC3G*C3GActive*Rap1Inactive/pow(Rap1Inactive + KmC3G, 2.0));
}

void dres_dkRapGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[27] = RapGapActive*Rap1Active/(Rap1Active + KmRapGap);
pd[28] = -(RapGapActive*Rap1Active/(Rap1Active + KmRapGap));
}

void dres_dKmRapGap_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[27] = -(kRapGap*RapGapActive*Rap1Active/pow(Rap1Active + KmRapGap, 2.0));
pd[28] = kRapGap*RapGapActive*Rap1Active/pow(Rap1Active + KmRapGap, 2.0);
}

void dres_dkRap1ToBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[15] = -(Rap1Active*BRafInactive/(BRafInactive + KmRap1ToBRaf));
pd[16] = Rap1Active*BRafInactive/(BRafInactive + KmRap1ToBRaf);
}

void dres_dKmRap1ToBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[15] = kRap1ToBRaf*Rap1Active*BRafInactive/pow(BRafInactive + KmRap1ToBRaf, 2.0);
pd[16] = -(kRap1ToBRaf*Rap1Active*BRafInactive/pow(BRafInactive + KmRap1ToBRaf, 2.0));
}

void dres_dkdRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[13] = Raf1PPtase*Raf1Active/(Raf1Active + KmdRaf1);
pd[14] = -(Raf1PPtase*Raf1Active/(Raf1Active + KmdRaf1));
}

void dres_dKmdRaf1_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[13] = -(kdRaf1*Raf1PPtase*Raf1Active/pow(Raf1Active + KmdRaf1, 2.0));
pd[14] = kdRaf1*Raf1PPtase*Raf1Active/pow(Raf1Active + KmdRaf1, 2.0);
}

void dres_dkdBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[15] = Raf1PPtase*BRafActive/(BRafActive + KmdBRaf);
pd[16] = -(Raf1PPtase*BRafActive/(BRafActive + KmdBRaf));
}

void dres_dKmdBRaf_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double NGF = dynamicVars[1];
double freeEGFReceptor = dynamicVars[2];
double boundEGFReceptor = dynamicVars[3];
double freeNGFReceptor = dynamicVars[4];
double boundNGFReceptor = dynamicVars[5];
double SosInactive = dynamicVars[6];
double SosActive = dynamicVars[7];
double P90RskInactive = dynamicVars[8];
double P90RskActive = dynamicVars[9];
double RasInactive = dynamicVars[10];
double RasActive = dynamicVars[11];
double RasGapActive = dynamicVars[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Active = dynamicVars[14];
double BRafInactive = dynamicVars[15];
double BRafActive = dynamicVars[16];
double MekInactive = dynamicVars[17];
double MekActive = dynamicVars[18];
double ErkInactive = dynamicVars[19];
double ErkActive = dynamicVars[20];
double PI3KInactive = dynamicVars[21];
double PI3KActive = dynamicVars[22];
double AktInactive = dynamicVars[23];
double AktActive = dynamicVars[24];
double C3GInactive = dynamicVars[25];
double C3GActive = dynamicVars[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Active = dynamicVars[28];
double RapGapActive = dynamicVars[29];
double PP2AActive = dynamicVars[30];
double Raf1PPtase = dynamicVars[31];


pd[15] = -(kdBRaf*Raf1PPtase*BRafActive/pow(BRafActive + KmdBRaf, 2.0));
pd[16] = kdBRaf*Raf1PPtase*BRafActive/pow(BRafActive + KmdBRaf, 2.0);
}

void sens_rhs_(double *time_ptr, double *sens_y, double *sens_yp, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar){

res_function_(time_ptr, sens_y, sens_yp, cj_ptr, sens_res, ires_ptr, constants, ipar);

int p_index = (int)constants[49];
double constants_only[49];
int jj;
for (jj = 0; jj < 49; jj++){
constants_only[jj] = constants[jj];}
double *dc_dp = &sens_y[32];
double *dcdot_dp = &sens_yp[32];
double *dres_dp = &sens_res[32];
int ii;
for(ii = 0; ii < 32; ii++){
dres_dp[ii] = 0;}
switch(p_index)
{
case 0 : dres_dkrbEGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 1 : dres_dkruEGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 2 : dres_dkrbNGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 3 : dres_dkruNGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 4 : dres_dkEGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 5 : dres_dKmEGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 6 : dres_dkNGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 7 : dres_dKmNGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 8 : dres_dkdSos_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 9 : dres_dKmdSos_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 10 : dres_dkSos_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 11 : dres_dKmSos_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 12 : dres_dkRasGap_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 13 : dres_dKmRasGap_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 14 : dres_dkRasToRaf1_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 15 : dres_dKmRasToRaf1_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 16 : dres_dkpRaf1_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 17 : dres_dKmpRaf1_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 18 : dres_dkpBRaf_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 19 : dres_dKmpBRaf_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 20 : dres_dkdMek_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 21 : dres_dKmdMek_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 22 : dres_dkpMekCytoplasmic_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 23 : dres_dKmpMekCytoplasmic_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 24 : dres_dkdErk_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 25 : dres_dKmdErk_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 26 : dres_dkpP90Rsk_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 27 : dres_dKmpP90Rsk_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 28 : dres_dkPI3K_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 29 : dres_dKmPI3K_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 30 : dres_dkPI3KRas_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 31 : dres_dKmPI3KRas_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 32 : dres_dkAkt_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 33 : dres_dKmAkt_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 34 : dres_dkdRaf1ByAkt_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 35 : dres_dKmRaf1ByAkt_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 36 : dres_dkC3GNGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 37 : dres_dKmC3GNGF_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 38 : dres_dkC3G_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 39 : dres_dKmC3G_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 40 : dres_dkRapGap_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 41 : dres_dKmRapGap_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 42 : dres_dkRap1ToBRaf_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 43 : dres_dKmRap1ToBRaf_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 44 : dres_dkdRaf1_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 45 : dres_dKmdRaf1_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 46 : dres_dkdBRaf_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 47 : dres_dKmdBRaf_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
}
double dres_dc[1024] = {0};
dres_dc_function_(time_ptr, sens_y, sens_yp, constants, dres_dc);
int row, col;
for(row = 0; row < 32; row++){
for(col = 0; col < 32; col++){
sens_res[row+32] += dres_dc[row + col*32]*dc_dp[col];}}
double dres_dcdot[1024] = {0};
dres_dcdot_function_(time_ptr, sens_y, sens_yp, constants, dres_dcdot);
for(row = 0; row < 32; row++){
for(col = 0; col < 32; col++){
sens_res[row+32] += dres_dcdot[row + col*32]*dcdot_dp[col];}}
}

void res_function_logdv_(double *time_ptr, double *log_dv, double *log_yp, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar){
double dynamicVars[32];
double yprime[32];
int ii;
for(ii = 0; ii < 32; ii++){
dynamicVars[ii] = max(exp(log_dv[ii]), DBL_MIN);
yprime[ii] = log_yp[ii] * dynamicVars[ii];}
res_function_(time_ptr, dynamicVars, yprime, cj_ptr, residual, ires_ptr, constants, ipar);
}

void root_func_logdv_(int *neq_ptr, double *time_ptr, double *log_dv, double *log_yp, int *nrt_ptr, double *root_devs, double *constants, int *ipar){
double dynamicVars[32];
double yprime[32];
int ii;
for(ii = 0; ii < 32; ii++){
dynamicVars[ii] = max(exp(log_dv[ii]), DBL_MIN);
yprime[ii] = log_yp[ii] * dynamicVars[ii];}
root_func_(neq_ptr, time_ptr, dynamicVars, yprime, nrt_ptr, root_devs, constants, ipar);
}

void sens_rhs_logdv_(double *time_ptr, double *sens_y_log, double *sens_yp_log, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar){
double sens_y[64];
double sens_yp[64];
int ii;
for(ii = 0; ii < 32; ii++){
sens_y[ii] = max(exp(sens_y_log[ii]), DBL_MIN);
sens_yp[ii] = sens_yp_log[ii] * sens_y[ii];}
for(ii = 32; ii < 64; ii++){
sens_y[ii] = sens_y_log[ii];
sens_yp[ii] = sens_yp_log[ii];}
sens_rhs_(time_ptr, sens_y, sens_yp, cj_ptr, sens_res, ires_ptr, constants, ipar);
}

void integrate_stochastic_tidbit_(unsigned long* seed_ptr, int* reseed, double* time_ptr, int* dv, double* cv, double* rmsd_ptr, double* stop_time_ptr, double* trajectory) {
  int i; /* Temp variables */

  unsigned long seed = *seed_ptr;
  if (*reseed) {init_genrand(seed);}

  short stch[26][32] = {{-1, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {1, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, -1, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 1, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
  short depd[26+1][26] = {{1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},
                    {1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0},
                    {0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0},
                    {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1},
                    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1},
                    {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};

  double time = *time_ptr;
  double sd = (*rmsd_ptr)*(*rmsd_ptr)*32.;
  double stop_time = *stop_time_ptr;
  double dt=0.0;

  double dv0[32];
  for (i=0;i<32;i++) {dv0[i]=dv[i];}

  int rxnInd = 26;
  double propensity, selection, props[26], av[0];
  while (time < stop_time) {

    if (depd[rxnInd][0]) {props[0]=cv[1]*dv[0]*dv[2];}
    if (depd[rxnInd][1]) {props[1]=cv[2]*dv[3];}
    if (depd[rxnInd][2]) {props[2]=cv[3]*dv[1]*dv[4];}
    if (depd[rxnInd][3]) {props[3]=cv[4]*dv[5];}
    if (depd[rxnInd][4]) {props[4]=cv[5]*dv[3]*dv[6]/(dv[6] + cv[6]);}
    if (depd[rxnInd][5]) {props[5]=cv[7]*dv[5]*dv[6]/(dv[6] + cv[8]);}
    if (depd[rxnInd][6]) {props[6]=cv[9]*dv[9]*dv[7]/(dv[7] + cv[10]);}
    if (depd[rxnInd][7]) {props[7]=cv[11]*dv[7]*dv[10]/(dv[10] + cv[12]);}
    if (depd[rxnInd][8]) {props[8]=cv[13]*dv[12]*dv[11]/(dv[11] + cv[14]);}
    if (depd[rxnInd][9]) {props[9]=cv[15]*dv[11]*dv[13]/(dv[13] + cv[16]);}
    if (depd[rxnInd][10]) {props[10]=cv[17]*dv[14]*dv[17]/(dv[17] + cv[18]);}
    if (depd[rxnInd][11]) {props[11]=cv[19]*dv[16]*dv[17]/(dv[17] + cv[20]);}
    if (depd[rxnInd][12]) {props[12]=cv[23]*dv[18]*dv[19]/(dv[19] + cv[24]);}
    if (depd[rxnInd][13]) {props[13]=cv[21]*dv[30]*dv[18]/(dv[18] + cv[22]);}
    if (depd[rxnInd][14]) {props[14]=cv[25]*dv[30]*dv[20]/(dv[20] + cv[26]);}
    if (depd[rxnInd][15]) {props[15]=cv[45]*dv[31]*dv[14]/(dv[14] + cv[46]);}
    if (depd[rxnInd][16]) {props[16]=cv[27]*dv[20]*dv[8]/(dv[8] + cv[28]);}
    if (depd[rxnInd][17]) {props[17]=cv[29]*dv[3]*dv[21]/(dv[21] + cv[30]);}
    if (depd[rxnInd][18]) {props[18]=cv[31]*dv[11]*dv[21]/(dv[21] + cv[32]);}
    if (depd[rxnInd][19]) {props[19]=cv[33]*dv[22]*dv[23]/(dv[23] + cv[34]);}
    if (depd[rxnInd][20]) {props[20]=cv[35]*dv[24]*dv[14]/(dv[14] + cv[36]);}
    if (depd[rxnInd][21]) {props[21]=cv[37]*dv[5]*dv[25]/(dv[25] + cv[38]);}
    if (depd[rxnInd][22]) {props[22]=cv[39]*dv[26]*dv[27]/(dv[27] + cv[40]);}
    if (depd[rxnInd][23]) {props[23]=cv[41]*dv[29]*dv[28]/(dv[28] + cv[42]);}
    if (depd[rxnInd][24]) {props[24]=cv[43]*dv[28]*dv[15]/(dv[15] + cv[44]);}
    if (depd[rxnInd][25]) {props[25]=cv[47]*dv[31]*dv[16]/(dv[16] + cv[48]);}

    propensity = 0.0;
    for (i=0;i<26;i++) {
      propensity += props[i];}
   if (propensity<=0.0) {
      dt = stop_time-time;
      time = stop_time;
      break;
   }

    dt = -log(1.0-genrand_real32())/propensity;
    time += dt;

    selection = propensity * genrand_real32();

    for (rxnInd=0; rxnInd<26; rxnInd++) {
      if (selection < props[rxnInd]) {break;}
      else {selection -= props[rxnInd];}}

    for (i=0;i<32;i++) {dv[i]+=stch[rxnInd][i];}

    double _sd = 0.0;
    for (i=0;i<32;i++) {
        _sd += (dv0[i]-dv[i])*(dv0[i]-dv[i]);
    }
    if (_sd > sd) {break;}
  }

  for (i=0;i<32;i++) {
    trajectory[i]=(double)dv[i];
    if (time > stop_time) {
      trajectory[i] += (double)stch[rxnInd][i]/dt*(stop_time - time);
    }
  }
  if (time>stop_time) {(*stop_time_ptr) = stop_time;}
  else {(*stop_time_ptr) = time;}

  (*time_ptr) = time;
}


void root_func_(int *neq_ptr, double *time_ptr, double *dynamicVars, double *yprime, int *nrt_ptr, double *root_devs, double *constants, int *ipar){
double time = *time_ptr;

double cell = constants[0];
double krbEGF = constants[1];
double kruEGF = constants[2];
double krbNGF = constants[3];
double kruNGF = constants[4];
double kEGF = constants[5];
double KmEGF = constants[6];
double kNGF = constants[7];
double KmNGF = constants[8];
double kdSos = constants[9];
double KmdSos = constants[10];
double kSos = constants[11];
double KmSos = constants[12];
double kRasGap = constants[13];
double KmRasGap = constants[14];
double kRasToRaf1 = constants[15];
double KmRasToRaf1 = constants[16];
double kpRaf1 = constants[17];
double KmpRaf1 = constants[18];
double kpBRaf = constants[19];
double KmpBRaf = constants[20];
double kdMek = constants[21];
double KmdMek = constants[22];
double kpMekCytoplasmic = constants[23];
double KmpMekCytoplasmic = constants[24];
double kdErk = constants[25];
double KmdErk = constants[26];
double kpP90Rsk = constants[27];
double KmpP90Rsk = constants[28];
double kPI3K = constants[29];
double KmPI3K = constants[30];
double kPI3KRas = constants[31];
double KmPI3KRas = constants[32];
double kAkt = constants[33];
double KmAkt = constants[34];
double kdRaf1ByAkt = constants[35];
double KmRaf1ByAkt = constants[36];
double kC3GNGF = constants[37];
double KmC3GNGF = constants[38];
double kC3G = constants[39];
double KmC3G = constants[40];
double kRapGap = constants[41];
double KmRapGap = constants[42];
double kRap1ToBRaf = constants[43];
double KmRap1ToBRaf = constants[44];
double kdRaf1 = constants[45];
double KmdRaf1 = constants[46];
double kdBRaf = constants[47];
double KmdBRaf = constants[48];

double EGF = dynamicVars[0];
double EGF_deriv_wrt_time = yprime[0];
double NGF = dynamicVars[1];
double NGF_deriv_wrt_time = yprime[1];
double freeEGFReceptor = dynamicVars[2];
double freeEGFReceptor_deriv_wrt_time = yprime[2];
double boundEGFReceptor = dynamicVars[3];
double boundEGFReceptor_deriv_wrt_time = yprime[3];
double freeNGFReceptor = dynamicVars[4];
double freeNGFReceptor_deriv_wrt_time = yprime[4];
double boundNGFReceptor = dynamicVars[5];
double boundNGFReceptor_deriv_wrt_time = yprime[5];
double SosInactive = dynamicVars[6];
double SosInactive_deriv_wrt_time = yprime[6];
double SosActive = dynamicVars[7];
double SosActive_deriv_wrt_time = yprime[7];
double P90RskInactive = dynamicVars[8];
double P90RskInactive_deriv_wrt_time = yprime[8];
double P90RskActive = dynamicVars[9];
double P90RskActive_deriv_wrt_time = yprime[9];
double RasInactive = dynamicVars[10];
double RasInactive_deriv_wrt_time = yprime[10];
double RasActive = dynamicVars[11];
double RasActive_deriv_wrt_time = yprime[11];
double RasGapActive = dynamicVars[12];
double RasGapActive_deriv_wrt_time = yprime[12];
double Raf1Inactive = dynamicVars[13];
double Raf1Inactive_deriv_wrt_time = yprime[13];
double Raf1Active = dynamicVars[14];
double Raf1Active_deriv_wrt_time = yprime[14];
double BRafInactive = dynamicVars[15];
double BRafInactive_deriv_wrt_time = yprime[15];
double BRafActive = dynamicVars[16];
double BRafActive_deriv_wrt_time = yprime[16];
double MekInactive = dynamicVars[17];
double MekInactive_deriv_wrt_time = yprime[17];
double MekActive = dynamicVars[18];
double MekActive_deriv_wrt_time = yprime[18];
double ErkInactive = dynamicVars[19];
double ErkInactive_deriv_wrt_time = yprime[19];
double ErkActive = dynamicVars[20];
double ErkActive_deriv_wrt_time = yprime[20];
double PI3KInactive = dynamicVars[21];
double PI3KInactive_deriv_wrt_time = yprime[21];
double PI3KActive = dynamicVars[22];
double PI3KActive_deriv_wrt_time = yprime[22];
double AktInactive = dynamicVars[23];
double AktInactive_deriv_wrt_time = yprime[23];
double AktActive = dynamicVars[24];
double AktActive_deriv_wrt_time = yprime[24];
double C3GInactive = dynamicVars[25];
double C3GInactive_deriv_wrt_time = yprime[25];
double C3GActive = dynamicVars[26];
double C3GActive_deriv_wrt_time = yprime[26];
double Rap1Inactive = dynamicVars[27];
double Rap1Inactive_deriv_wrt_time = yprime[27];
double Rap1Active = dynamicVars[28];
double Rap1Active_deriv_wrt_time = yprime[28];
double RapGapActive = dynamicVars[29];
double RapGapActive_deriv_wrt_time = yprime[29];
double PP2AActive = dynamicVars[30];
double PP2AActive_deriv_wrt_time = yprime[30];
double Raf1PPtase = dynamicVars[31];
double Raf1PPtase_deriv_wrt_time = yprime[31];


}
