#include <math.h>
#include <stdio.h>
#include <float.h>
#include "mtrand.h"
#define exponentiale M_E
#define pi M_PI
double max(double a, double b){
return a > b ? a : b;}
double root(double n,double x);

double root_0(double n,double x);

double root_1(double n,double x);

double cot(double x);

double cot_0(double x);

double arccot(double x);

double arccot_0(double x);

double coth(double x);

double coth_0(double x);

double csc(double x);

double csc_0(double x);

double arccsc(double x);

double arccsc_0(double x);

double csch(double x);

double csch_0(double x);

double sec(double x);

double sec_0(double x);

double arcsec(double x);

double arcsec_0(double x);

double sech(double x);

double sech_0(double x);

double phi(double X,double k_X,double v_X);

double phi_0(double X,double k_X,double v_X);

double phi_1(double X,double k_X,double v_X);

double phi_2(double X,double k_X,double v_X);

double psi(double X,double k_X,double v_X);

double psi_0(double X,double k_X,double v_X);

double psi_1(double X,double k_X,double v_X);

double psi_2(double X,double k_X,double v_X);

void res_function_(double *time_ptr, double *dynamicVars, double *yprime, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar);

void alg_deriv_func_(double *alg_yp, double *dynamicVars, double *yp, double *time_ptr, double *constants, double *alg_derivs_res);

void alg_res_func_(double *alg_vals, double *dynamicVars, double *time_ptr, double *constants, double *residual);

void dres_dc_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dcdot_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void ddaskr_jac_(double *time_ptr, double *dynamicVars, double *yprime, double *pd, double *cj_ptr, double *constants, int *intpar);

void dres_dK_WGen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_CNen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_WGwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_CIDwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_CNwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_CIDptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_CNptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_Bcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_ENcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_PTCCID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_ENhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_CNhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dK_PTC_HH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dmaxPTC_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dmaxHH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dC_CID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_WGen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_CNen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_WGwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_CIDwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_CNwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_CIDptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_CNptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_Bcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_ENcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_PTCCID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_ENhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dnu_CNhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_en_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_EN_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_wg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_IWG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_EWG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_ptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_PTC_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_cid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_CID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_CN_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_hh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_HH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dH_PH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dalpha_wg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dbeta_wg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dEndo_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dExo_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dMxfer_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dLMxfer_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dLMxfer_PTC_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void dres_dLMxfer_HH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd);

void sens_rhs_(double *time_ptr, double *sens_y, double *sens_yp, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar);

void res_function_logdv_(double *time_ptr, double *log_dv, double *log_yp, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar);

void root_func_logdv_(int *neq_ptr, double *time_ptr, double *log_dv, double *log_yp, int *nrt_ptr, double *root_devs, double *constants, int *ipar);

void sens_rhs_logdv_(double *time_ptr, double *sens_y_log, double *sens_yp_log, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar);

void integrate_stochatic_tidbit_(unsigned long* seed_ptr, int* reseed, double* time_ptr, int* dv, double* cv, double* rmsd_ptr, double* stop_time_ptr, double* trajectory);

void root_func_(int *neq_ptr, double *time_ptr, double *dynamicVars, double *yprime, int *nrt_ptr, double *root_devs, double *constants, int *ipar);

double root(double n,double x){
return pow(x, 1.0/n);
}

double root_0(double n,double x){
return -(log(x)*pow(x, 1.0/n)*1.0/pow(n, 2.0));
}

double root_1(double n,double x){
return pow(x, 1.0/n - 1.0)/n;
}

double cot(double x){
return 1.0/tan(x);
}

double cot_0(double x){
return -(1.0/(pow(cos(x), 2.0)*pow(tan(x), 2.0)));
}

double arccot(double x){
return atan(1.0/x);
}

double arccot_0(double x){
return -(1.0/pow(x, 2.0)/(pow(1.0/x, 2.0) + 1.0));
}

double coth(double x){
return 1.0/tanh(x);
}

double coth_0(double x){
return -(1.0/(pow(cosh(x), 2.0)*pow(tanh(x), 2.0)));
}

double csc(double x){
return 1.0/sin(x);
}

double csc_0(double x){
return -(cos(x)/pow(sin(x), 2.0));
}

double arccsc(double x){
return asin(1.0/x);
}

double arccsc_0(double x){
return -(1.0/pow(x, 2.0)/sqrt(1.0 - pow(1.0/x, 2.0)));
}

double csch(double x){
return 1.0/sinh(x);
}

double csch_0(double x){
return -(cosh(x)/pow(sinh(x), 2.0));
}

double sec(double x){
return 1.0/cos(x);
}

double sec_0(double x){
return sin(x)/pow(cos(x), 2.0);
}

double arcsec(double x){
return acos(1.0/x);
}

double arcsec_0(double x){
return -(1.0/pow(x, 2.0)/sqrt(1.0 - pow(1.0/x, 2.0)));
}

double sech(double x){
return 1.0/cosh(x);
}

double sech_0(double x){
return -(sinh(x)/pow(cosh(x), 2.0));
}

double phi(double X,double k_X,double v_X){return pow(pow(X, 2.0), v_X/2.0)/(pow(pow(k_X, 2.0), v_X/2.0) + pow(pow(X, 2.0), v_X/2.0));}

double phi_0(double X,double k_X,double v_X){return v_X*pow(pow(X, 2.0), v_X*0.5 - 1.0)*X/(pow(pow(k_X, 2.0), v_X*0.5) + pow(pow(X, 2.0), v_X*0.5)) - pow(pow(X, 2.0), v_X*0.5)*v_X*pow(pow(X, 2.0), v_X*0.5 - 1.0)*X/pow(pow(pow(k_X, 2.0), v_X*0.5) + pow(pow(X, 2.0), v_X*0.5), 2.0);}

double phi_1(double X,double k_X,double v_X){return -(pow(pow(X, 2.0), v_X*0.5)*v_X*pow(pow(k_X, 2.0), v_X*0.5 - 1.0)*k_X/pow(pow(pow(k_X, 2.0), v_X*0.5) + pow(pow(X, 2.0), v_X*0.5), 2.0));}

double phi_2(double X,double k_X,double v_X){return log(pow(X, 2.0))*pow(pow(X, 2.0), v_X*0.5)*0.5/(pow(pow(k_X, 2.0), v_X*0.5) + pow(pow(X, 2.0), v_X*0.5)) - pow(pow(X, 2.0), v_X*0.5)*(log(pow(k_X, 2.0))*pow(pow(k_X, 2.0), v_X*0.5)*0.5 + log(pow(X, 2.0))*pow(pow(X, 2.0), v_X*0.5)*0.5)/pow(pow(pow(k_X, 2.0), v_X*0.5) + pow(pow(X, 2.0), v_X*0.5), 2.0);}

double psi(double X,double k_X,double v_X){return 1.0 - phi(X, k_X, v_X);}

double psi_0(double X,double k_X,double v_X){return -phi_0(X, k_X, v_X);}

double psi_1(double X,double k_X,double v_X){return -phi_1(X, k_X, v_X);}

double psi_2(double X,double k_X,double v_X){return -phi_2(X, k_X, v_X);}

void res_function_(double *time_ptr, double *dynamicVars, double *yprime, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

residual[0] = T_0/H_en*(phi(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_0) - yprime[0];
residual[1] = T_0/H_en*(phi(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_1) - yprime[1];
residual[2] = T_0/H_en*(phi(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_2) - yprime[2];
residual[3] = T_0/H_en*(phi(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_3) - yprime[3];
residual[4] = T_0/H_EN*(en_cell_0 - EN_cell_0) - yprime[4];
residual[5] = T_0/H_EN*(en_cell_1 - EN_cell_1) - yprime[5];
residual[6] = T_0/H_EN*(en_cell_2 - EN_cell_2) - yprime[6];
residual[7] = T_0/H_EN*(en_cell_3 - EN_cell_3) - yprime[7];
residual[8] = T_0/H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))/(1.0 + beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg)) - T_0/H_wg*wg_cell_0 - yprime[8];
residual[9] = T_0/H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))/(1.0 + beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg)) - T_0/H_wg*wg_cell_1 - yprime[9];
residual[10] = T_0/H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))/(1.0 + beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg)) - T_0/H_wg*wg_cell_2 - yprime[10];
residual[11] = T_0/H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))/(1.0 + beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg)) - T_0/H_wg*wg_cell_3 - yprime[11];
residual[12] = T_0/H_IWG*(wg_cell_0 - IWG_cell_0) + T_0*(Endo_WG*EWG_tot_cell_0 - Exo_WG*IWG_cell_0) - yprime[12];
residual[13] = T_0/H_IWG*(wg_cell_1 - IWG_cell_1) + T_0*(Endo_WG*EWG_tot_cell_1 - Exo_WG*IWG_cell_1) - yprime[13];
residual[14] = T_0/H_IWG*(wg_cell_2 - IWG_cell_2) + T_0*(Endo_WG*EWG_tot_cell_2 - Exo_WG*IWG_cell_2) - yprime[14];
residual[15] = T_0/H_IWG*(wg_cell_3 - IWG_cell_3) + T_0*(Endo_WG*EWG_tot_cell_3 - Exo_WG*IWG_cell_3) - yprime[15];
residual[16] = T_0*Exo_WG*IWG_cell_0/6.0 + -(T_0*Endo_WG*EWG_cell_0_side_0) + T_0*Mxfer_WG*(EWG_cell_0_side_3 - EWG_cell_0_side_0) + T_0*LMxfer_WG*(EWG_cell_0_side_5 + EWG_cell_0_side_1 - 2.0*EWG_cell_0_side_0) + -T_0/H_EWG*EWG_cell_0_side_0 - yprime[16];
residual[17] = T_0*Exo_WG*IWG_cell_0/6.0 + -(T_0*Endo_WG*EWG_cell_0_side_1) + T_0*Mxfer_WG*(EWG_cell_1_side_4 - EWG_cell_0_side_1) + T_0*LMxfer_WG*(EWG_cell_0_side_0 + EWG_cell_0_side_2 - 2.0*EWG_cell_0_side_1) + -T_0/H_EWG*EWG_cell_0_side_1 - yprime[17];
residual[18] = T_0*Exo_WG*IWG_cell_0/6.0 + -(T_0*Endo_WG*EWG_cell_0_side_2) + T_0*Mxfer_WG*(EWG_cell_1_side_5 - EWG_cell_0_side_2) + T_0*LMxfer_WG*(EWG_cell_0_side_1 + EWG_cell_0_side_3 - 2.0*EWG_cell_0_side_2) + -T_0/H_EWG*EWG_cell_0_side_2 - yprime[18];
residual[19] = T_0*Exo_WG*IWG_cell_0/6.0 + -(T_0*Endo_WG*EWG_cell_0_side_3) + T_0*Mxfer_WG*(EWG_cell_0_side_0 - EWG_cell_0_side_3) + T_0*LMxfer_WG*(EWG_cell_0_side_2 + EWG_cell_0_side_4 - 2.0*EWG_cell_0_side_3) + -T_0/H_EWG*EWG_cell_0_side_3 - yprime[19];
residual[20] = T_0*Exo_WG*IWG_cell_0/6.0 + -(T_0*Endo_WG*EWG_cell_0_side_4) + T_0*Mxfer_WG*(EWG_cell_3_side_1 - EWG_cell_0_side_4) + T_0*LMxfer_WG*(EWG_cell_0_side_3 + EWG_cell_0_side_5 - 2.0*EWG_cell_0_side_4) + -T_0/H_EWG*EWG_cell_0_side_4 - yprime[20];
residual[21] = T_0*Exo_WG*IWG_cell_0/6.0 + -(T_0*Endo_WG*EWG_cell_0_side_5) + T_0*Mxfer_WG*(EWG_cell_3_side_2 - EWG_cell_0_side_5) + T_0*LMxfer_WG*(EWG_cell_0_side_4 + EWG_cell_0_side_0 - 2.0*EWG_cell_0_side_5) + -T_0/H_EWG*EWG_cell_0_side_5 - yprime[21];
residual[22] = T_0*Exo_WG*IWG_cell_1/6.0 + -(T_0*Endo_WG*EWG_cell_1_side_0) + T_0*Mxfer_WG*(EWG_cell_1_side_3 - EWG_cell_1_side_0) + T_0*LMxfer_WG*(EWG_cell_1_side_5 + EWG_cell_1_side_1 - 2.0*EWG_cell_1_side_0) + -T_0/H_EWG*EWG_cell_1_side_0 - yprime[22];
residual[23] = T_0*Exo_WG*IWG_cell_1/6.0 + -(T_0*Endo_WG*EWG_cell_1_side_1) + T_0*Mxfer_WG*(EWG_cell_2_side_4 - EWG_cell_1_side_1) + T_0*LMxfer_WG*(EWG_cell_1_side_0 + EWG_cell_1_side_2 - 2.0*EWG_cell_1_side_1) + -T_0/H_EWG*EWG_cell_1_side_1 - yprime[23];
residual[24] = T_0*Exo_WG*IWG_cell_1/6.0 + -(T_0*Endo_WG*EWG_cell_1_side_2) + T_0*Mxfer_WG*(EWG_cell_2_side_5 - EWG_cell_1_side_2) + T_0*LMxfer_WG*(EWG_cell_1_side_1 + EWG_cell_1_side_3 - 2.0*EWG_cell_1_side_2) + -T_0/H_EWG*EWG_cell_1_side_2 - yprime[24];
residual[25] = T_0*Exo_WG*IWG_cell_1/6.0 + -(T_0*Endo_WG*EWG_cell_1_side_3) + T_0*Mxfer_WG*(EWG_cell_1_side_0 - EWG_cell_1_side_3) + T_0*LMxfer_WG*(EWG_cell_1_side_2 + EWG_cell_1_side_4 - 2.0*EWG_cell_1_side_3) + -T_0/H_EWG*EWG_cell_1_side_3 - yprime[25];
residual[26] = T_0*Exo_WG*IWG_cell_1/6.0 + -(T_0*Endo_WG*EWG_cell_1_side_4) + T_0*Mxfer_WG*(EWG_cell_0_side_1 - EWG_cell_1_side_4) + T_0*LMxfer_WG*(EWG_cell_1_side_3 + EWG_cell_1_side_5 - 2.0*EWG_cell_1_side_4) + -T_0/H_EWG*EWG_cell_1_side_4 - yprime[26];
residual[27] = T_0*Exo_WG*IWG_cell_1/6.0 + -(T_0*Endo_WG*EWG_cell_1_side_5) + T_0*Mxfer_WG*(EWG_cell_0_side_2 - EWG_cell_1_side_5) + T_0*LMxfer_WG*(EWG_cell_1_side_4 + EWG_cell_1_side_0 - 2.0*EWG_cell_1_side_5) + -T_0/H_EWG*EWG_cell_1_side_5 - yprime[27];
residual[28] = T_0*Exo_WG*IWG_cell_2/6.0 + -(T_0*Endo_WG*EWG_cell_2_side_0) + T_0*Mxfer_WG*(EWG_cell_2_side_3 - EWG_cell_2_side_0) + T_0*LMxfer_WG*(EWG_cell_2_side_5 + EWG_cell_2_side_1 - 2.0*EWG_cell_2_side_0) + -T_0/H_EWG*EWG_cell_2_side_0 - yprime[28];
residual[29] = T_0*Exo_WG*IWG_cell_2/6.0 + -(T_0*Endo_WG*EWG_cell_2_side_1) + T_0*Mxfer_WG*(EWG_cell_3_side_4 - EWG_cell_2_side_1) + T_0*LMxfer_WG*(EWG_cell_2_side_0 + EWG_cell_2_side_2 - 2.0*EWG_cell_2_side_1) + -T_0/H_EWG*EWG_cell_2_side_1 - yprime[29];
residual[30] = T_0*Exo_WG*IWG_cell_2/6.0 + -(T_0*Endo_WG*EWG_cell_2_side_2) + T_0*Mxfer_WG*(EWG_cell_3_side_5 - EWG_cell_2_side_2) + T_0*LMxfer_WG*(EWG_cell_2_side_1 + EWG_cell_2_side_3 - 2.0*EWG_cell_2_side_2) + -T_0/H_EWG*EWG_cell_2_side_2 - yprime[30];
residual[31] = T_0*Exo_WG*IWG_cell_2/6.0 + -(T_0*Endo_WG*EWG_cell_2_side_3) + T_0*Mxfer_WG*(EWG_cell_2_side_0 - EWG_cell_2_side_3) + T_0*LMxfer_WG*(EWG_cell_2_side_2 + EWG_cell_2_side_4 - 2.0*EWG_cell_2_side_3) + -T_0/H_EWG*EWG_cell_2_side_3 - yprime[31];
residual[32] = T_0*Exo_WG*IWG_cell_2/6.0 + -(T_0*Endo_WG*EWG_cell_2_side_4) + T_0*Mxfer_WG*(EWG_cell_1_side_1 - EWG_cell_2_side_4) + T_0*LMxfer_WG*(EWG_cell_2_side_3 + EWG_cell_2_side_5 - 2.0*EWG_cell_2_side_4) + -T_0/H_EWG*EWG_cell_2_side_4 - yprime[32];
residual[33] = T_0*Exo_WG*IWG_cell_2/6.0 + -(T_0*Endo_WG*EWG_cell_2_side_5) + T_0*Mxfer_WG*(EWG_cell_1_side_2 - EWG_cell_2_side_5) + T_0*LMxfer_WG*(EWG_cell_2_side_4 + EWG_cell_2_side_0 - 2.0*EWG_cell_2_side_5) + -T_0/H_EWG*EWG_cell_2_side_5 - yprime[33];
residual[34] = T_0*Exo_WG*IWG_cell_3/6.0 + -(T_0*Endo_WG*EWG_cell_3_side_0) + T_0*Mxfer_WG*(EWG_cell_3_side_3 - EWG_cell_3_side_0) + T_0*LMxfer_WG*(EWG_cell_3_side_5 + EWG_cell_3_side_1 - 2.0*EWG_cell_3_side_0) + -T_0/H_EWG*EWG_cell_3_side_0 - yprime[34];
residual[35] = T_0*Exo_WG*IWG_cell_3/6.0 + -(T_0*Endo_WG*EWG_cell_3_side_1) + T_0*Mxfer_WG*(EWG_cell_0_side_4 - EWG_cell_3_side_1) + T_0*LMxfer_WG*(EWG_cell_3_side_0 + EWG_cell_3_side_2 - 2.0*EWG_cell_3_side_1) + -T_0/H_EWG*EWG_cell_3_side_1 - yprime[35];
residual[36] = T_0*Exo_WG*IWG_cell_3/6.0 + -(T_0*Endo_WG*EWG_cell_3_side_2) + T_0*Mxfer_WG*(EWG_cell_0_side_5 - EWG_cell_3_side_2) + T_0*LMxfer_WG*(EWG_cell_3_side_1 + EWG_cell_3_side_3 - 2.0*EWG_cell_3_side_2) + -T_0/H_EWG*EWG_cell_3_side_2 - yprime[36];
residual[37] = T_0*Exo_WG*IWG_cell_3/6.0 + -(T_0*Endo_WG*EWG_cell_3_side_3) + T_0*Mxfer_WG*(EWG_cell_3_side_0 - EWG_cell_3_side_3) + T_0*LMxfer_WG*(EWG_cell_3_side_2 + EWG_cell_3_side_4 - 2.0*EWG_cell_3_side_3) + -T_0/H_EWG*EWG_cell_3_side_3 - yprime[37];
residual[38] = T_0*Exo_WG*IWG_cell_3/6.0 + -(T_0*Endo_WG*EWG_cell_3_side_4) + T_0*Mxfer_WG*(EWG_cell_2_side_1 - EWG_cell_3_side_4) + T_0*LMxfer_WG*(EWG_cell_3_side_3 + EWG_cell_3_side_5 - 2.0*EWG_cell_3_side_4) + -T_0/H_EWG*EWG_cell_3_side_4 - yprime[38];
residual[39] = T_0*Exo_WG*IWG_cell_3/6.0 + -(T_0*Endo_WG*EWG_cell_3_side_5) + T_0*Mxfer_WG*(EWG_cell_2_side_2 - EWG_cell_3_side_5) + T_0*LMxfer_WG*(EWG_cell_3_side_4 + EWG_cell_3_side_0 - 2.0*EWG_cell_3_side_5) + -T_0/H_EWG*EWG_cell_3_side_5 - yprime[39];
residual[40] = T_0/H_ptc*(phi(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_0) - yprime[40];
residual[41] = T_0/H_ptc*(phi(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_1) - yprime[41];
residual[42] = T_0/H_ptc*(phi(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_2) - yprime[42];
residual[43] = T_0/H_ptc*(phi(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_3) - yprime[43];
residual[44] = T_0/H_PTC*(ptc_cell_0/6.0 - PTC_cell_0_side_0) + -(T_0*K_PTC_HH*maxHH*HH_cell_0_side_3*PTC_cell_0_side_0) + T_0*LMxfer_PTC*(PTC_cell_0_side_5 + PTC_cell_0_side_1 - 2.0*PTC_cell_0_side_0) - yprime[44];
residual[45] = T_0/H_PTC*(ptc_cell_0/6.0 - PTC_cell_0_side_1) + -(T_0*K_PTC_HH*maxHH*HH_cell_1_side_4*PTC_cell_0_side_1) + T_0*LMxfer_PTC*(PTC_cell_0_side_0 + PTC_cell_0_side_2 - 2.0*PTC_cell_0_side_1) - yprime[45];
residual[46] = T_0/H_PTC*(ptc_cell_0/6.0 - PTC_cell_0_side_2) + -(T_0*K_PTC_HH*maxHH*HH_cell_1_side_5*PTC_cell_0_side_2) + T_0*LMxfer_PTC*(PTC_cell_0_side_1 + PTC_cell_0_side_3 - 2.0*PTC_cell_0_side_2) - yprime[46];
residual[47] = T_0/H_PTC*(ptc_cell_0/6.0 - PTC_cell_0_side_3) + -(T_0*K_PTC_HH*maxHH*HH_cell_0_side_0*PTC_cell_0_side_3) + T_0*LMxfer_PTC*(PTC_cell_0_side_2 + PTC_cell_0_side_4 - 2.0*PTC_cell_0_side_3) - yprime[47];
residual[48] = T_0/H_PTC*(ptc_cell_0/6.0 - PTC_cell_0_side_4) + -(T_0*K_PTC_HH*maxHH*HH_cell_3_side_1*PTC_cell_0_side_4) + T_0*LMxfer_PTC*(PTC_cell_0_side_3 + PTC_cell_0_side_5 - 2.0*PTC_cell_0_side_4) - yprime[48];
residual[49] = T_0/H_PTC*(ptc_cell_0/6.0 - PTC_cell_0_side_5) + -(T_0*K_PTC_HH*maxHH*HH_cell_3_side_2*PTC_cell_0_side_5) + T_0*LMxfer_PTC*(PTC_cell_0_side_4 + PTC_cell_0_side_0 - 2.0*PTC_cell_0_side_5) - yprime[49];
residual[50] = T_0/H_PTC*(ptc_cell_1/6.0 - PTC_cell_1_side_0) + -(T_0*K_PTC_HH*maxHH*HH_cell_1_side_3*PTC_cell_1_side_0) + T_0*LMxfer_PTC*(PTC_cell_1_side_5 + PTC_cell_1_side_1 - 2.0*PTC_cell_1_side_0) - yprime[50];
residual[51] = T_0/H_PTC*(ptc_cell_1/6.0 - PTC_cell_1_side_1) + -(T_0*K_PTC_HH*maxHH*HH_cell_2_side_4*PTC_cell_1_side_1) + T_0*LMxfer_PTC*(PTC_cell_1_side_0 + PTC_cell_1_side_2 - 2.0*PTC_cell_1_side_1) - yprime[51];
residual[52] = T_0/H_PTC*(ptc_cell_1/6.0 - PTC_cell_1_side_2) + -(T_0*K_PTC_HH*maxHH*HH_cell_2_side_5*PTC_cell_1_side_2) + T_0*LMxfer_PTC*(PTC_cell_1_side_1 + PTC_cell_1_side_3 - 2.0*PTC_cell_1_side_2) - yprime[52];
residual[53] = T_0/H_PTC*(ptc_cell_1/6.0 - PTC_cell_1_side_3) + -(T_0*K_PTC_HH*maxHH*HH_cell_1_side_0*PTC_cell_1_side_3) + T_0*LMxfer_PTC*(PTC_cell_1_side_2 + PTC_cell_1_side_4 - 2.0*PTC_cell_1_side_3) - yprime[53];
residual[54] = T_0/H_PTC*(ptc_cell_1/6.0 - PTC_cell_1_side_4) + -(T_0*K_PTC_HH*maxHH*HH_cell_0_side_1*PTC_cell_1_side_4) + T_0*LMxfer_PTC*(PTC_cell_1_side_3 + PTC_cell_1_side_5 - 2.0*PTC_cell_1_side_4) - yprime[54];
residual[55] = T_0/H_PTC*(ptc_cell_1/6.0 - PTC_cell_1_side_5) + -(T_0*K_PTC_HH*maxHH*HH_cell_0_side_2*PTC_cell_1_side_5) + T_0*LMxfer_PTC*(PTC_cell_1_side_4 + PTC_cell_1_side_0 - 2.0*PTC_cell_1_side_5) - yprime[55];
residual[56] = T_0/H_PTC*(ptc_cell_2/6.0 - PTC_cell_2_side_0) + -(T_0*K_PTC_HH*maxHH*HH_cell_2_side_3*PTC_cell_2_side_0) + T_0*LMxfer_PTC*(PTC_cell_2_side_5 + PTC_cell_2_side_1 - 2.0*PTC_cell_2_side_0) - yprime[56];
residual[57] = T_0/H_PTC*(ptc_cell_2/6.0 - PTC_cell_2_side_1) + -(T_0*K_PTC_HH*maxHH*HH_cell_3_side_4*PTC_cell_2_side_1) + T_0*LMxfer_PTC*(PTC_cell_2_side_0 + PTC_cell_2_side_2 - 2.0*PTC_cell_2_side_1) - yprime[57];
residual[58] = T_0/H_PTC*(ptc_cell_2/6.0 - PTC_cell_2_side_2) + -(T_0*K_PTC_HH*maxHH*HH_cell_3_side_5*PTC_cell_2_side_2) + T_0*LMxfer_PTC*(PTC_cell_2_side_1 + PTC_cell_2_side_3 - 2.0*PTC_cell_2_side_2) - yprime[58];
residual[59] = T_0/H_PTC*(ptc_cell_2/6.0 - PTC_cell_2_side_3) + -(T_0*K_PTC_HH*maxHH*HH_cell_2_side_0*PTC_cell_2_side_3) + T_0*LMxfer_PTC*(PTC_cell_2_side_2 + PTC_cell_2_side_4 - 2.0*PTC_cell_2_side_3) - yprime[59];
residual[60] = T_0/H_PTC*(ptc_cell_2/6.0 - PTC_cell_2_side_4) + -(T_0*K_PTC_HH*maxHH*HH_cell_1_side_1*PTC_cell_2_side_4) + T_0*LMxfer_PTC*(PTC_cell_2_side_3 + PTC_cell_2_side_5 - 2.0*PTC_cell_2_side_4) - yprime[60];
residual[61] = T_0/H_PTC*(ptc_cell_2/6.0 - PTC_cell_2_side_5) + -(T_0*K_PTC_HH*maxHH*HH_cell_1_side_2*PTC_cell_2_side_5) + T_0*LMxfer_PTC*(PTC_cell_2_side_4 + PTC_cell_2_side_0 - 2.0*PTC_cell_2_side_5) - yprime[61];
residual[62] = T_0/H_PTC*(ptc_cell_3/6.0 - PTC_cell_3_side_0) + -(T_0*K_PTC_HH*maxHH*HH_cell_3_side_3*PTC_cell_3_side_0) + T_0*LMxfer_PTC*(PTC_cell_3_side_5 + PTC_cell_3_side_1 - 2.0*PTC_cell_3_side_0) - yprime[62];
residual[63] = T_0/H_PTC*(ptc_cell_3/6.0 - PTC_cell_3_side_1) + -(T_0*K_PTC_HH*maxHH*HH_cell_0_side_4*PTC_cell_3_side_1) + T_0*LMxfer_PTC*(PTC_cell_3_side_0 + PTC_cell_3_side_2 - 2.0*PTC_cell_3_side_1) - yprime[63];
residual[64] = T_0/H_PTC*(ptc_cell_3/6.0 - PTC_cell_3_side_2) + -(T_0*K_PTC_HH*maxHH*HH_cell_0_side_5*PTC_cell_3_side_2) + T_0*LMxfer_PTC*(PTC_cell_3_side_1 + PTC_cell_3_side_3 - 2.0*PTC_cell_3_side_2) - yprime[64];
residual[65] = T_0/H_PTC*(ptc_cell_3/6.0 - PTC_cell_3_side_3) + -(T_0*K_PTC_HH*maxHH*HH_cell_3_side_0*PTC_cell_3_side_3) + T_0*LMxfer_PTC*(PTC_cell_3_side_2 + PTC_cell_3_side_4 - 2.0*PTC_cell_3_side_3) - yprime[65];
residual[66] = T_0/H_PTC*(ptc_cell_3/6.0 - PTC_cell_3_side_4) + -(T_0*K_PTC_HH*maxHH*HH_cell_2_side_1*PTC_cell_3_side_4) + T_0*LMxfer_PTC*(PTC_cell_3_side_3 + PTC_cell_3_side_5 - 2.0*PTC_cell_3_side_4) - yprime[66];
residual[67] = T_0/H_PTC*(ptc_cell_3/6.0 - PTC_cell_3_side_5) + -(T_0*K_PTC_HH*maxHH*HH_cell_2_side_2*PTC_cell_3_side_5) + T_0*LMxfer_PTC*(PTC_cell_3_side_4 + PTC_cell_3_side_0 - 2.0*PTC_cell_3_side_5) - yprime[67];
residual[68] = T_0/H_cid*(phi(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_0) - yprime[68];
residual[69] = T_0/H_cid*(phi(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_1) - yprime[69];
residual[70] = T_0/H_cid*(phi(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_2) - yprime[70];
residual[71] = T_0/H_cid*(phi(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_3) - yprime[71];
residual[72] = T_0/H_CID*(cid_cell_0 - CID_cell_0) - T_0*C_CID*CID_cell_0*phi(PTC_tot_cell_0, K_PTCCID, nu_PTCCID) - yprime[72];
residual[73] = T_0/H_CID*(cid_cell_1 - CID_cell_1) - T_0*C_CID*CID_cell_1*phi(PTC_tot_cell_1, K_PTCCID, nu_PTCCID) - yprime[73];
residual[74] = T_0/H_CID*(cid_cell_2 - CID_cell_2) - T_0*C_CID*CID_cell_2*phi(PTC_tot_cell_2, K_PTCCID, nu_PTCCID) - yprime[74];
residual[75] = T_0/H_CID*(cid_cell_3 - CID_cell_3) - T_0*C_CID*CID_cell_3*phi(PTC_tot_cell_3, K_PTCCID, nu_PTCCID) - yprime[75];
residual[76] = T_0*C_CID*CID_cell_0*phi(PTC_tot_cell_0, K_PTCCID, nu_PTCCID) - T_0*CN_cell_0/H_CN - yprime[76];
residual[77] = T_0*C_CID*CID_cell_1*phi(PTC_tot_cell_1, K_PTCCID, nu_PTCCID) - T_0*CN_cell_1/H_CN - yprime[77];
residual[78] = T_0*C_CID*CID_cell_2*phi(PTC_tot_cell_2, K_PTCCID, nu_PTCCID) - T_0*CN_cell_2/H_CN - yprime[78];
residual[79] = T_0*C_CID*CID_cell_3*phi(PTC_tot_cell_3, K_PTCCID, nu_PTCCID) - T_0*CN_cell_3/H_CN - yprime[79];
residual[80] = T_0/H_hh*(phi(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_0) - yprime[80];
residual[81] = T_0/H_hh*(phi(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_1) - yprime[81];
residual[82] = T_0/H_hh*(phi(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_2) - yprime[82];
residual[83] = T_0/H_hh*(phi(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_3) - yprime[83];
residual[84] = T_0/H_HH*(hh_cell_0/6.0 - HH_cell_0_side_0) - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_3*HH_cell_0_side_0 + T_0*LMxfer_HH*(HH_cell_0_side_5 + HH_cell_0_side_1 - 2.0*HH_cell_0_side_0) - yprime[84];
residual[85] = T_0/H_HH*(hh_cell_0/6.0 - HH_cell_0_side_1) - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_4*HH_cell_0_side_1 + T_0*LMxfer_HH*(HH_cell_0_side_0 + HH_cell_0_side_2 - 2.0*HH_cell_0_side_1) - yprime[85];
residual[86] = T_0/H_HH*(hh_cell_0/6.0 - HH_cell_0_side_2) - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_5*HH_cell_0_side_2 + T_0*LMxfer_HH*(HH_cell_0_side_1 + HH_cell_0_side_3 - 2.0*HH_cell_0_side_2) - yprime[86];
residual[87] = T_0/H_HH*(hh_cell_0/6.0 - HH_cell_0_side_3) - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_0*HH_cell_0_side_3 + T_0*LMxfer_HH*(HH_cell_0_side_2 + HH_cell_0_side_4 - 2.0*HH_cell_0_side_3) - yprime[87];
residual[88] = T_0/H_HH*(hh_cell_0/6.0 - HH_cell_0_side_4) - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_1*HH_cell_0_side_4 + T_0*LMxfer_HH*(HH_cell_0_side_3 + HH_cell_0_side_5 - 2.0*HH_cell_0_side_4) - yprime[88];
residual[89] = T_0/H_HH*(hh_cell_0/6.0 - HH_cell_0_side_5) - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_2*HH_cell_0_side_5 + T_0*LMxfer_HH*(HH_cell_0_side_4 + HH_cell_0_side_0 - 2.0*HH_cell_0_side_5) - yprime[89];
residual[90] = T_0/H_HH*(hh_cell_1/6.0 - HH_cell_1_side_0) - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_3*HH_cell_1_side_0 + T_0*LMxfer_HH*(HH_cell_1_side_5 + HH_cell_1_side_1 - 2.0*HH_cell_1_side_0) - yprime[90];
residual[91] = T_0/H_HH*(hh_cell_1/6.0 - HH_cell_1_side_1) - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_4*HH_cell_1_side_1 + T_0*LMxfer_HH*(HH_cell_1_side_0 + HH_cell_1_side_2 - 2.0*HH_cell_1_side_1) - yprime[91];
residual[92] = T_0/H_HH*(hh_cell_1/6.0 - HH_cell_1_side_2) - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_5*HH_cell_1_side_2 + T_0*LMxfer_HH*(HH_cell_1_side_1 + HH_cell_1_side_3 - 2.0*HH_cell_1_side_2) - yprime[92];
residual[93] = T_0/H_HH*(hh_cell_1/6.0 - HH_cell_1_side_3) - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_0*HH_cell_1_side_3 + T_0*LMxfer_HH*(HH_cell_1_side_2 + HH_cell_1_side_4 - 2.0*HH_cell_1_side_3) - yprime[93];
residual[94] = T_0/H_HH*(hh_cell_1/6.0 - HH_cell_1_side_4) - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_1*HH_cell_1_side_4 + T_0*LMxfer_HH*(HH_cell_1_side_3 + HH_cell_1_side_5 - 2.0*HH_cell_1_side_4) - yprime[94];
residual[95] = T_0/H_HH*(hh_cell_1/6.0 - HH_cell_1_side_5) - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_2*HH_cell_1_side_5 + T_0*LMxfer_HH*(HH_cell_1_side_4 + HH_cell_1_side_0 - 2.0*HH_cell_1_side_5) - yprime[95];
residual[96] = T_0/H_HH*(hh_cell_2/6.0 - HH_cell_2_side_0) - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_3*HH_cell_2_side_0 + T_0*LMxfer_HH*(HH_cell_2_side_5 + HH_cell_2_side_1 - 2.0*HH_cell_2_side_0) - yprime[96];
residual[97] = T_0/H_HH*(hh_cell_2/6.0 - HH_cell_2_side_1) - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_4*HH_cell_2_side_1 + T_0*LMxfer_HH*(HH_cell_2_side_0 + HH_cell_2_side_2 - 2.0*HH_cell_2_side_1) - yprime[97];
residual[98] = T_0/H_HH*(hh_cell_2/6.0 - HH_cell_2_side_2) - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_5*HH_cell_2_side_2 + T_0*LMxfer_HH*(HH_cell_2_side_1 + HH_cell_2_side_3 - 2.0*HH_cell_2_side_2) - yprime[98];
residual[99] = T_0/H_HH*(hh_cell_2/6.0 - HH_cell_2_side_3) - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_0*HH_cell_2_side_3 + T_0*LMxfer_HH*(HH_cell_2_side_2 + HH_cell_2_side_4 - 2.0*HH_cell_2_side_3) - yprime[99];
residual[100] = T_0/H_HH*(hh_cell_2/6.0 - HH_cell_2_side_4) - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_1*HH_cell_2_side_4 + T_0*LMxfer_HH*(HH_cell_2_side_3 + HH_cell_2_side_5 - 2.0*HH_cell_2_side_4) - yprime[100];
residual[101] = T_0/H_HH*(hh_cell_2/6.0 - HH_cell_2_side_5) - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_2*HH_cell_2_side_5 + T_0*LMxfer_HH*(HH_cell_2_side_4 + HH_cell_2_side_0 - 2.0*HH_cell_2_side_5) - yprime[101];
residual[102] = T_0/H_HH*(hh_cell_3/6.0 - HH_cell_3_side_0) - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_3*HH_cell_3_side_0 + T_0*LMxfer_HH*(HH_cell_3_side_5 + HH_cell_3_side_1 - 2.0*HH_cell_3_side_0) - yprime[102];
residual[103] = T_0/H_HH*(hh_cell_3/6.0 - HH_cell_3_side_1) - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_4*HH_cell_3_side_1 + T_0*LMxfer_HH*(HH_cell_3_side_0 + HH_cell_3_side_2 - 2.0*HH_cell_3_side_1) - yprime[103];
residual[104] = T_0/H_HH*(hh_cell_3/6.0 - HH_cell_3_side_2) - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_5*HH_cell_3_side_2 + T_0*LMxfer_HH*(HH_cell_3_side_1 + HH_cell_3_side_3 - 2.0*HH_cell_3_side_2) - yprime[104];
residual[105] = T_0/H_HH*(hh_cell_3/6.0 - HH_cell_3_side_3) - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_0*HH_cell_3_side_3 + T_0*LMxfer_HH*(HH_cell_3_side_2 + HH_cell_3_side_4 - 2.0*HH_cell_3_side_3) - yprime[105];
residual[106] = T_0/H_HH*(hh_cell_3/6.0 - HH_cell_3_side_4) - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_1*HH_cell_3_side_4 + T_0*LMxfer_HH*(HH_cell_3_side_3 + HH_cell_3_side_5 - 2.0*HH_cell_3_side_4) - yprime[106];
residual[107] = T_0/H_HH*(hh_cell_3/6.0 - HH_cell_3_side_5) - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_2*HH_cell_3_side_5 + T_0*LMxfer_HH*(HH_cell_3_side_4 + HH_cell_3_side_0 - 2.0*HH_cell_3_side_5) - yprime[107];
residual[108] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_3*PTC_cell_0_side_0 - T_0*PH_cell_0_side_0/H_PH - yprime[108];
residual[109] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_4*PTC_cell_0_side_1 - T_0*PH_cell_0_side_1/H_PH - yprime[109];
residual[110] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_5*PTC_cell_0_side_2 - T_0*PH_cell_0_side_2/H_PH - yprime[110];
residual[111] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_0*PTC_cell_0_side_3 - T_0*PH_cell_0_side_3/H_PH - yprime[111];
residual[112] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_1*PTC_cell_0_side_4 - T_0*PH_cell_0_side_4/H_PH - yprime[112];
residual[113] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_2*PTC_cell_0_side_5 - T_0*PH_cell_0_side_5/H_PH - yprime[113];
residual[114] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_3*PTC_cell_1_side_0 - T_0*PH_cell_1_side_0/H_PH - yprime[114];
residual[115] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_4*PTC_cell_1_side_1 - T_0*PH_cell_1_side_1/H_PH - yprime[115];
residual[116] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_5*PTC_cell_1_side_2 - T_0*PH_cell_1_side_2/H_PH - yprime[116];
residual[117] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_0*PTC_cell_1_side_3 - T_0*PH_cell_1_side_3/H_PH - yprime[117];
residual[118] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_1*PTC_cell_1_side_4 - T_0*PH_cell_1_side_4/H_PH - yprime[118];
residual[119] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_2*PTC_cell_1_side_5 - T_0*PH_cell_1_side_5/H_PH - yprime[119];
residual[120] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_3*PTC_cell_2_side_0 - T_0*PH_cell_2_side_0/H_PH - yprime[120];
residual[121] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_4*PTC_cell_2_side_1 - T_0*PH_cell_2_side_1/H_PH - yprime[121];
residual[122] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_5*PTC_cell_2_side_2 - T_0*PH_cell_2_side_2/H_PH - yprime[122];
residual[123] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_0*PTC_cell_2_side_3 - T_0*PH_cell_2_side_3/H_PH - yprime[123];
residual[124] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_1*PTC_cell_2_side_4 - T_0*PH_cell_2_side_4/H_PH - yprime[124];
residual[125] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_2*PTC_cell_2_side_5 - T_0*PH_cell_2_side_5/H_PH - yprime[125];
residual[126] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_3*PTC_cell_3_side_0 - T_0*PH_cell_3_side_0/H_PH - yprime[126];
residual[127] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_4*PTC_cell_3_side_1 - T_0*PH_cell_3_side_1/H_PH - yprime[127];
residual[128] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_5*PTC_cell_3_side_2 - T_0*PH_cell_3_side_2/H_PH - yprime[128];
residual[129] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_0*PTC_cell_3_side_3 - T_0*PH_cell_3_side_3/H_PH - yprime[129];
residual[130] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_1*PTC_cell_3_side_4 - T_0*PH_cell_3_side_4/H_PH - yprime[130];
residual[131] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_2*PTC_cell_3_side_5 - T_0*PH_cell_3_side_5/H_PH - yprime[131];
}

void alg_deriv_func_(double *alg_yp, double *dynamicVars, double *yp, double *time_ptr, double *constants, double *alg_derivs_res){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

}

void alg_res_func_(double *alg_vals, double *dynamicVars, double *time_ptr, double *constants, double *residual){
double time = *time_ptr;


double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

}

void dres_dc_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = -(T_0/H_en);
pd[2112] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[2508] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[3432] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[3564] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[4620] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[4752] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[10032] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_0*psi_0(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[133] = -(T_0/H_en);
pd[2245] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[2377] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[2905] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[3301] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[4225] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[4357] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[10165] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_1*psi_0(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[266] = -(T_0/H_en);
pd[3038] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[3170] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[3698] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[4094] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[5018] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[5150] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[10298] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_2*psi_0(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[399] = -(T_0/H_en);
pd[2643] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[2775] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[3831] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[3963] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[4491] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[4887] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*psi(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[10431] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_3*psi_0(CN_cell_3, K_CNen, nu_CNen)/H_en;
pd[4] = T_0/H_EN;
pd[532] = -(T_0/H_EN);
pd[137] = T_0/H_EN;
pd[665] = -(T_0/H_EN);
pd[270] = T_0/H_EN;
pd[798] = -(T_0/H_EN);
pd[403] = T_0/H_EN;
pd[931] = -(T_0/H_EN);
pd[1064] = -(T_0/H_wg);
pd[1592] = T_0*alpha_wg*phi_0(IWG_cell_0, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_0(IWG_cell_0, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9512] = T_0*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_0, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_0, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10040] = T_0*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_0*psi_0(CN_cell_0, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_0*psi_0(CN_cell_0, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[1197] = -(T_0/H_wg);
pd[1725] = T_0*alpha_wg*phi_0(IWG_cell_1, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_0(IWG_cell_1, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9645] = T_0*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_1, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_1, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10173] = T_0*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_1*psi_0(CN_cell_1, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_1*psi_0(CN_cell_1, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[1330] = -(T_0/H_wg);
pd[1858] = T_0*alpha_wg*phi_0(IWG_cell_2, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_0(IWG_cell_2, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9778] = T_0*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_2, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_2, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10306] = T_0*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_2*psi_0(CN_cell_2, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_2*psi_0(CN_cell_2, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[1463] = -(T_0/H_wg);
pd[1991] = T_0*alpha_wg*phi_0(IWG_cell_3, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_0(IWG_cell_3, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9911] = T_0*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_3, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*psi(CN_cell_3, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10439] = T_0*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_3*psi_0(CN_cell_3, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_3*psi_0(CN_cell_3, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[1068] = T_0/H_IWG;
pd[1596] = -(T_0/H_IWG) - T_0*Exo_WG;
pd[2124] = T_0*Endo_WG;
pd[2256] = T_0*Endo_WG;
pd[2388] = T_0*Endo_WG;
pd[2520] = T_0*Endo_WG;
pd[2652] = T_0*Endo_WG;
pd[2784] = T_0*Endo_WG;
pd[1201] = T_0/H_IWG;
pd[1729] = -(T_0/H_IWG) - T_0*Exo_WG;
pd[2917] = T_0*Endo_WG;
pd[3049] = T_0*Endo_WG;
pd[3181] = T_0*Endo_WG;
pd[3313] = T_0*Endo_WG;
pd[3445] = T_0*Endo_WG;
pd[3577] = T_0*Endo_WG;
pd[1334] = T_0/H_IWG;
pd[1862] = -(T_0/H_IWG) - T_0*Exo_WG;
pd[3710] = T_0*Endo_WG;
pd[3842] = T_0*Endo_WG;
pd[3974] = T_0*Endo_WG;
pd[4106] = T_0*Endo_WG;
pd[4238] = T_0*Endo_WG;
pd[4370] = T_0*Endo_WG;
pd[1467] = T_0/H_IWG;
pd[1995] = -(T_0/H_IWG) - T_0*Exo_WG;
pd[4503] = T_0*Endo_WG;
pd[4635] = T_0*Endo_WG;
pd[4767] = T_0*Endo_WG;
pd[4899] = T_0*Endo_WG;
pd[5031] = T_0*Endo_WG;
pd[5163] = T_0*Endo_WG;
pd[1600] = T_0*Exo_WG*0.166666666667;
pd[2128] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[2260] = T_0*LMxfer_WG;
pd[2524] = T_0*Mxfer_WG;
pd[2788] = T_0*LMxfer_WG;
pd[1601] = T_0*Exo_WG*0.166666666667;
pd[2129] = T_0*LMxfer_WG;
pd[2261] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[2393] = T_0*LMxfer_WG;
pd[3449] = T_0*Mxfer_WG;
pd[1602] = T_0*Exo_WG*0.166666666667;
pd[2262] = T_0*LMxfer_WG;
pd[2394] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[2526] = T_0*LMxfer_WG;
pd[3582] = T_0*Mxfer_WG;
pd[1603] = T_0*Exo_WG*0.166666666667;
pd[2131] = T_0*Mxfer_WG;
pd[2395] = T_0*LMxfer_WG;
pd[2527] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[2659] = T_0*LMxfer_WG;
pd[1604] = T_0*Exo_WG*0.166666666667;
pd[2528] = T_0*LMxfer_WG;
pd[2660] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[2792] = T_0*LMxfer_WG;
pd[4640] = T_0*Mxfer_WG;
pd[1605] = T_0*Exo_WG*0.166666666667;
pd[2133] = T_0*LMxfer_WG;
pd[2661] = T_0*LMxfer_WG;
pd[2793] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4773] = T_0*Mxfer_WG;
pd[1738] = T_0*Exo_WG*0.166666666667;
pd[2926] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3058] = T_0*LMxfer_WG;
pd[3322] = T_0*Mxfer_WG;
pd[3586] = T_0*LMxfer_WG;
pd[1739] = T_0*Exo_WG*0.166666666667;
pd[2927] = T_0*LMxfer_WG;
pd[3059] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3191] = T_0*LMxfer_WG;
pd[4247] = T_0*Mxfer_WG;
pd[1740] = T_0*Exo_WG*0.166666666667;
pd[3060] = T_0*LMxfer_WG;
pd[3192] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3324] = T_0*LMxfer_WG;
pd[4380] = T_0*Mxfer_WG;
pd[1741] = T_0*Exo_WG*0.166666666667;
pd[2929] = T_0*Mxfer_WG;
pd[3193] = T_0*LMxfer_WG;
pd[3325] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3457] = T_0*LMxfer_WG;
pd[1742] = T_0*Exo_WG*0.166666666667;
pd[2270] = T_0*Mxfer_WG;
pd[3326] = T_0*LMxfer_WG;
pd[3458] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3590] = T_0*LMxfer_WG;
pd[1743] = T_0*Exo_WG*0.166666666667;
pd[2403] = T_0*Mxfer_WG;
pd[2931] = T_0*LMxfer_WG;
pd[3459] = T_0*LMxfer_WG;
pd[3591] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[1876] = T_0*Exo_WG*0.166666666667;
pd[3724] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3856] = T_0*LMxfer_WG;
pd[4120] = T_0*Mxfer_WG;
pd[4384] = T_0*LMxfer_WG;
pd[1877] = T_0*Exo_WG*0.166666666667;
pd[3725] = T_0*LMxfer_WG;
pd[3857] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[3989] = T_0*LMxfer_WG;
pd[5045] = T_0*Mxfer_WG;
pd[1878] = T_0*Exo_WG*0.166666666667;
pd[3858] = T_0*LMxfer_WG;
pd[3990] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4122] = T_0*LMxfer_WG;
pd[5178] = T_0*Mxfer_WG;
pd[1879] = T_0*Exo_WG*0.166666666667;
pd[3727] = T_0*Mxfer_WG;
pd[3991] = T_0*LMxfer_WG;
pd[4123] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4255] = T_0*LMxfer_WG;
pd[1880] = T_0*Exo_WG*0.166666666667;
pd[3068] = T_0*Mxfer_WG;
pd[4124] = T_0*LMxfer_WG;
pd[4256] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4388] = T_0*LMxfer_WG;
pd[1881] = T_0*Exo_WG*0.166666666667;
pd[3201] = T_0*Mxfer_WG;
pd[3729] = T_0*LMxfer_WG;
pd[4257] = T_0*LMxfer_WG;
pd[4389] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[2014] = T_0*Exo_WG*0.166666666667;
pd[4522] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4654] = T_0*LMxfer_WG;
pd[4918] = T_0*Mxfer_WG;
pd[5182] = T_0*LMxfer_WG;
pd[2015] = T_0*Exo_WG*0.166666666667;
pd[2675] = T_0*Mxfer_WG;
pd[4523] = T_0*LMxfer_WG;
pd[4655] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4787] = T_0*LMxfer_WG;
pd[2016] = T_0*Exo_WG*0.166666666667;
pd[2808] = T_0*Mxfer_WG;
pd[4656] = T_0*LMxfer_WG;
pd[4788] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[4920] = T_0*LMxfer_WG;
pd[2017] = T_0*Exo_WG*0.166666666667;
pd[4525] = T_0*Mxfer_WG;
pd[4789] = T_0*LMxfer_WG;
pd[4921] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[5053] = T_0*LMxfer_WG;
pd[2018] = T_0*Exo_WG*0.166666666667;
pd[3866] = T_0*Mxfer_WG;
pd[4922] = T_0*LMxfer_WG;
pd[5054] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[5186] = T_0*LMxfer_WG;
pd[2019] = T_0*Exo_WG*0.166666666667;
pd[3999] = T_0*Mxfer_WG;
pd[4527] = T_0*LMxfer_WG;
pd[5055] = T_0*LMxfer_WG;
pd[5187] = -(T_0*Endo_WG) - T_0*Mxfer_WG - T_0*LMxfer_WG*2.0 - T_0/H_EWG;
pd[5320] = -(T_0/H_ptc);
pd[9544] = T_0*phi_0(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*psi(CN_cell_0, K_CNptc, nu_CNptc)/H_ptc;
pd[10072] = T_0*phi_0(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_0*psi_0(CN_cell_0, K_CNptc, nu_CNptc)/H_ptc;
pd[5453] = -(T_0/H_ptc);
pd[9677] = T_0*phi_0(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*psi(CN_cell_1, K_CNptc, nu_CNptc)/H_ptc;
pd[10205] = T_0*phi_0(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_1*psi_0(CN_cell_1, K_CNptc, nu_CNptc)/H_ptc;
pd[5586] = -(T_0/H_ptc);
pd[9810] = T_0*phi_0(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*psi(CN_cell_2, K_CNptc, nu_CNptc)/H_ptc;
pd[10338] = T_0*phi_0(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_2*psi_0(CN_cell_2, K_CNptc, nu_CNptc)/H_ptc;
pd[5719] = -(T_0/H_ptc);
pd[9943] = T_0*phi_0(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*psi(CN_cell_3, K_CNptc, nu_CNptc)/H_ptc;
pd[10471] = T_0*phi_0(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_3*psi_0(CN_cell_3, K_CNptc, nu_CNptc)/H_ptc;
pd[5324] = T_0*0.166666666667/H_PTC;
pd[5852] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_0_side_3 - T_0*LMxfer_PTC*2.0;
pd[5984] = T_0*LMxfer_PTC;
pd[6512] = T_0*LMxfer_PTC;
pd[11528] = -(T_0*K_PTC_HH*maxHH*PTC_cell_0_side_0);
pd[5325] = T_0*0.166666666667/H_PTC;
pd[5853] = T_0*LMxfer_PTC;
pd[5985] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_1_side_4 - T_0*LMxfer_PTC*2.0;
pd[6117] = T_0*LMxfer_PTC;
pd[12453] = -(T_0*K_PTC_HH*maxHH*PTC_cell_0_side_1);
pd[5326] = T_0*0.166666666667/H_PTC;
pd[5986] = T_0*LMxfer_PTC;
pd[6118] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_1_side_5 - T_0*LMxfer_PTC*2.0;
pd[6250] = T_0*LMxfer_PTC;
pd[12586] = -(T_0*K_PTC_HH*maxHH*PTC_cell_0_side_2);
pd[5327] = T_0*0.166666666667/H_PTC;
pd[6119] = T_0*LMxfer_PTC;
pd[6251] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_0_side_0 - T_0*LMxfer_PTC*2.0;
pd[6383] = T_0*LMxfer_PTC;
pd[11135] = -(T_0*K_PTC_HH*maxHH*PTC_cell_0_side_3);
pd[5328] = T_0*0.166666666667/H_PTC;
pd[6252] = T_0*LMxfer_PTC;
pd[6384] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_3_side_1 - T_0*LMxfer_PTC*2.0;
pd[6516] = T_0*LMxfer_PTC;
pd[13644] = -(T_0*K_PTC_HH*maxHH*PTC_cell_0_side_4);
pd[5329] = T_0*0.166666666667/H_PTC;
pd[5857] = T_0*LMxfer_PTC;
pd[6385] = T_0*LMxfer_PTC;
pd[6517] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_3_side_2 - T_0*LMxfer_PTC*2.0;
pd[13777] = -(T_0*K_PTC_HH*maxHH*PTC_cell_0_side_5);
pd[5462] = T_0*0.166666666667/H_PTC;
pd[6650] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_1_side_3 - T_0*LMxfer_PTC*2.0;
pd[6782] = T_0*LMxfer_PTC;
pd[7310] = T_0*LMxfer_PTC;
pd[12326] = -(T_0*K_PTC_HH*maxHH*PTC_cell_1_side_0);
pd[5463] = T_0*0.166666666667/H_PTC;
pd[6651] = T_0*LMxfer_PTC;
pd[6783] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_2_side_4 - T_0*LMxfer_PTC*2.0;
pd[6915] = T_0*LMxfer_PTC;
pd[13251] = -(T_0*K_PTC_HH*maxHH*PTC_cell_1_side_1);
pd[5464] = T_0*0.166666666667/H_PTC;
pd[6784] = T_0*LMxfer_PTC;
pd[6916] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_2_side_5 - T_0*LMxfer_PTC*2.0;
pd[7048] = T_0*LMxfer_PTC;
pd[13384] = -(T_0*K_PTC_HH*maxHH*PTC_cell_1_side_2);
pd[5465] = T_0*0.166666666667/H_PTC;
pd[6917] = T_0*LMxfer_PTC;
pd[7049] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_1_side_0 - T_0*LMxfer_PTC*2.0;
pd[7181] = T_0*LMxfer_PTC;
pd[11933] = -(T_0*K_PTC_HH*maxHH*PTC_cell_1_side_3);
pd[5466] = T_0*0.166666666667/H_PTC;
pd[7050] = T_0*LMxfer_PTC;
pd[7182] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_0_side_1 - T_0*LMxfer_PTC*2.0;
pd[7314] = T_0*LMxfer_PTC;
pd[11274] = -(T_0*K_PTC_HH*maxHH*PTC_cell_1_side_4);
pd[5467] = T_0*0.166666666667/H_PTC;
pd[6655] = T_0*LMxfer_PTC;
pd[7183] = T_0*LMxfer_PTC;
pd[7315] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_0_side_2 - T_0*LMxfer_PTC*2.0;
pd[11407] = -(T_0*K_PTC_HH*maxHH*PTC_cell_1_side_5);
pd[5600] = T_0*0.166666666667/H_PTC;
pd[7448] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_2_side_3 - T_0*LMxfer_PTC*2.0;
pd[7580] = T_0*LMxfer_PTC;
pd[8108] = T_0*LMxfer_PTC;
pd[13124] = -(T_0*K_PTC_HH*maxHH*PTC_cell_2_side_0);
pd[5601] = T_0*0.166666666667/H_PTC;
pd[7449] = T_0*LMxfer_PTC;
pd[7581] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_3_side_4 - T_0*LMxfer_PTC*2.0;
pd[7713] = T_0*LMxfer_PTC;
pd[14049] = -(T_0*K_PTC_HH*maxHH*PTC_cell_2_side_1);
pd[5602] = T_0*0.166666666667/H_PTC;
pd[7582] = T_0*LMxfer_PTC;
pd[7714] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_3_side_5 - T_0*LMxfer_PTC*2.0;
pd[7846] = T_0*LMxfer_PTC;
pd[14182] = -(T_0*K_PTC_HH*maxHH*PTC_cell_2_side_2);
pd[5603] = T_0*0.166666666667/H_PTC;
pd[7715] = T_0*LMxfer_PTC;
pd[7847] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_2_side_0 - T_0*LMxfer_PTC*2.0;
pd[7979] = T_0*LMxfer_PTC;
pd[12731] = -(T_0*K_PTC_HH*maxHH*PTC_cell_2_side_3);
pd[5604] = T_0*0.166666666667/H_PTC;
pd[7848] = T_0*LMxfer_PTC;
pd[7980] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_1_side_1 - T_0*LMxfer_PTC*2.0;
pd[8112] = T_0*LMxfer_PTC;
pd[12072] = -(T_0*K_PTC_HH*maxHH*PTC_cell_2_side_4);
pd[5605] = T_0*0.166666666667/H_PTC;
pd[7453] = T_0*LMxfer_PTC;
pd[7981] = T_0*LMxfer_PTC;
pd[8113] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_1_side_2 - T_0*LMxfer_PTC*2.0;
pd[12205] = -(T_0*K_PTC_HH*maxHH*PTC_cell_2_side_5);
pd[5738] = T_0*0.166666666667/H_PTC;
pd[8246] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_3_side_3 - T_0*LMxfer_PTC*2.0;
pd[8378] = T_0*LMxfer_PTC;
pd[8906] = T_0*LMxfer_PTC;
pd[13922] = -(T_0*K_PTC_HH*maxHH*PTC_cell_3_side_0);
pd[5739] = T_0*0.166666666667/H_PTC;
pd[8247] = T_0*LMxfer_PTC;
pd[8379] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_0_side_4 - T_0*LMxfer_PTC*2.0;
pd[8511] = T_0*LMxfer_PTC;
pd[11679] = -(T_0*K_PTC_HH*maxHH*PTC_cell_3_side_1);
pd[5740] = T_0*0.166666666667/H_PTC;
pd[8380] = T_0*LMxfer_PTC;
pd[8512] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_0_side_5 - T_0*LMxfer_PTC*2.0;
pd[8644] = T_0*LMxfer_PTC;
pd[11812] = -(T_0*K_PTC_HH*maxHH*PTC_cell_3_side_2);
pd[5741] = T_0*0.166666666667/H_PTC;
pd[8513] = T_0*LMxfer_PTC;
pd[8645] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_3_side_0 - T_0*LMxfer_PTC*2.0;
pd[8777] = T_0*LMxfer_PTC;
pd[13529] = -(T_0*K_PTC_HH*maxHH*PTC_cell_3_side_3);
pd[5742] = T_0*0.166666666667/H_PTC;
pd[8646] = T_0*LMxfer_PTC;
pd[8778] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_2_side_1 - T_0*LMxfer_PTC*2.0;
pd[8910] = T_0*LMxfer_PTC;
pd[12870] = -(T_0*K_PTC_HH*maxHH*PTC_cell_3_side_4);
pd[5743] = T_0*0.166666666667/H_PTC;
pd[8251] = T_0*LMxfer_PTC;
pd[8779] = T_0*LMxfer_PTC;
pd[8911] = -(T_0/H_PTC) - T_0*K_PTC_HH*maxHH*HH_cell_2_side_2 - T_0*LMxfer_PTC*2.0;
pd[13003] = -(T_0*K_PTC_HH*maxHH*PTC_cell_3_side_5);
pd[596] = T_0*phi_0(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_0*psi_0(EN_cell_0, K_ENcid, nu_ENcid)/H_cid;
pd[9044] = -(T_0/H_cid);
pd[729] = T_0*phi_0(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_1*psi_0(EN_cell_1, K_ENcid, nu_ENcid)/H_cid;
pd[9177] = -(T_0/H_cid);
pd[862] = T_0*phi_0(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_2*psi_0(EN_cell_2, K_ENcid, nu_ENcid)/H_cid;
pd[9310] = -(T_0/H_cid);
pd[995] = T_0*phi_0(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_3*psi_0(EN_cell_3, K_ENcid, nu_ENcid)/H_cid;
pd[9443] = -(T_0/H_cid);
pd[5880] = -(T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[6012] = -(T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[6144] = -(T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[6276] = -(T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[6408] = -(T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[6540] = -(T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[9048] = T_0/H_CID;
pd[9576] = -(T_0/H_CID) - T_0*C_CID*phi(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[6673] = -(T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[6805] = -(T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[6937] = -(T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[7069] = -(T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[7201] = -(T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[7333] = -(T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[9181] = T_0/H_CID;
pd[9709] = -(T_0/H_CID) - T_0*C_CID*phi(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[7466] = -(T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[7598] = -(T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[7730] = -(T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[7862] = -(T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[7994] = -(T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[8126] = -(T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[9314] = T_0/H_CID;
pd[9842] = -(T_0/H_CID) - T_0*C_CID*phi(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[8259] = -(T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[8391] = -(T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[8523] = -(T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[8655] = -(T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[8787] = -(T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[8919] = -(T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[9447] = T_0/H_CID;
pd[9975] = -(T_0/H_CID) - T_0*C_CID*phi(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[5884] = T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[6016] = T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[6148] = T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[6280] = T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[6412] = T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[6544] = T_0*C_CID*CID_cell_0*phi_0(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[9580] = T_0*C_CID*phi(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[10108] = -(T_0/H_CN);
pd[6677] = T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[6809] = T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[6941] = T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[7073] = T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[7205] = T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[7337] = T_0*C_CID*CID_cell_1*phi_0(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[9713] = T_0*C_CID*phi(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[10241] = -(T_0/H_CN);
pd[7470] = T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[7602] = T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[7734] = T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[7866] = T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[7998] = T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[8130] = T_0*C_CID*CID_cell_2*phi_0(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[9846] = T_0*C_CID*phi(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[10374] = -(T_0/H_CN);
pd[8263] = T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[8395] = T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[8527] = T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[8659] = T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[8791] = T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[8923] = T_0*C_CID*CID_cell_3*phi_0(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[9979] = T_0*C_CID*phi(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
pd[10507] = -(T_0/H_CN);
pd[608] = T_0*phi_0(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*psi(CN_cell_0, K_CNhh, nu_CNhh)/H_hh;
pd[10112] = T_0*phi_0(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_0*psi_0(CN_cell_0, K_CNhh, nu_CNhh)/H_hh;
pd[10640] = -(T_0/H_hh);
pd[741] = T_0*phi_0(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*psi(CN_cell_1, K_CNhh, nu_CNhh)/H_hh;
pd[10245] = T_0*phi_0(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_1*psi_0(CN_cell_1, K_CNhh, nu_CNhh)/H_hh;
pd[10773] = -(T_0/H_hh);
pd[874] = T_0*phi_0(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*psi(CN_cell_2, K_CNhh, nu_CNhh)/H_hh;
pd[10378] = T_0*phi_0(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_2*psi_0(CN_cell_2, K_CNhh, nu_CNhh)/H_hh;
pd[10906] = -(T_0/H_hh);
pd[1007] = T_0*phi_0(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*psi(CN_cell_3, K_CNhh, nu_CNhh)/H_hh;
pd[10511] = T_0*phi_0(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_3*psi_0(CN_cell_3, K_CNhh, nu_CNhh)/H_hh;
pd[11039] = -(T_0/H_hh);
pd[6288] = -(T_0*K_PTC_HH*maxPTC*HH_cell_0_side_0);
pd[10644] = T_0*0.166666666667/H_HH;
pd[11172] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_3;
pd[11304] = T_0*LMxfer_HH;
pd[11832] = T_0*LMxfer_HH;
pd[7213] = -(T_0*K_PTC_HH*maxPTC*HH_cell_0_side_1);
pd[10645] = T_0*0.166666666667/H_HH;
pd[11173] = T_0*LMxfer_HH;
pd[11305] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_4;
pd[11437] = T_0*LMxfer_HH;
pd[7346] = -(T_0*K_PTC_HH*maxPTC*HH_cell_0_side_2);
pd[10646] = T_0*0.166666666667/H_HH;
pd[11306] = T_0*LMxfer_HH;
pd[11438] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_5;
pd[11570] = T_0*LMxfer_HH;
pd[5895] = -(T_0*K_PTC_HH*maxPTC*HH_cell_0_side_3);
pd[10647] = T_0*0.166666666667/H_HH;
pd[11439] = T_0*LMxfer_HH;
pd[11571] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_0;
pd[11703] = T_0*LMxfer_HH;
pd[8404] = -(T_0*K_PTC_HH*maxPTC*HH_cell_0_side_4);
pd[10648] = T_0*0.166666666667/H_HH;
pd[11572] = T_0*LMxfer_HH;
pd[11704] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_1;
pd[11836] = T_0*LMxfer_HH;
pd[8537] = -(T_0*K_PTC_HH*maxPTC*HH_cell_0_side_5);
pd[10649] = T_0*0.166666666667/H_HH;
pd[11177] = T_0*LMxfer_HH;
pd[11705] = T_0*LMxfer_HH;
pd[11837] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_2;
pd[7086] = -(T_0*K_PTC_HH*maxPTC*HH_cell_1_side_0);
pd[10782] = T_0*0.166666666667/H_HH;
pd[11970] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_3;
pd[12102] = T_0*LMxfer_HH;
pd[12630] = T_0*LMxfer_HH;
pd[8011] = -(T_0*K_PTC_HH*maxPTC*HH_cell_1_side_1);
pd[10783] = T_0*0.166666666667/H_HH;
pd[11971] = T_0*LMxfer_HH;
pd[12103] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_4;
pd[12235] = T_0*LMxfer_HH;
pd[8144] = -(T_0*K_PTC_HH*maxPTC*HH_cell_1_side_2);
pd[10784] = T_0*0.166666666667/H_HH;
pd[12104] = T_0*LMxfer_HH;
pd[12236] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_5;
pd[12368] = T_0*LMxfer_HH;
pd[6693] = -(T_0*K_PTC_HH*maxPTC*HH_cell_1_side_3);
pd[10785] = T_0*0.166666666667/H_HH;
pd[12237] = T_0*LMxfer_HH;
pd[12369] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_0;
pd[12501] = T_0*LMxfer_HH;
pd[6034] = -(T_0*K_PTC_HH*maxPTC*HH_cell_1_side_4);
pd[10786] = T_0*0.166666666667/H_HH;
pd[12370] = T_0*LMxfer_HH;
pd[12502] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_1;
pd[12634] = T_0*LMxfer_HH;
pd[6167] = -(T_0*K_PTC_HH*maxPTC*HH_cell_1_side_5);
pd[10787] = T_0*0.166666666667/H_HH;
pd[11975] = T_0*LMxfer_HH;
pd[12503] = T_0*LMxfer_HH;
pd[12635] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_2;
pd[7884] = -(T_0*K_PTC_HH*maxPTC*HH_cell_2_side_0);
pd[10920] = T_0*0.166666666667/H_HH;
pd[12768] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_3;
pd[12900] = T_0*LMxfer_HH;
pd[13428] = T_0*LMxfer_HH;
pd[8809] = -(T_0*K_PTC_HH*maxPTC*HH_cell_2_side_1);
pd[10921] = T_0*0.166666666667/H_HH;
pd[12769] = T_0*LMxfer_HH;
pd[12901] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_4;
pd[13033] = T_0*LMxfer_HH;
pd[8942] = -(T_0*K_PTC_HH*maxPTC*HH_cell_2_side_2);
pd[10922] = T_0*0.166666666667/H_HH;
pd[12902] = T_0*LMxfer_HH;
pd[13034] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_5;
pd[13166] = T_0*LMxfer_HH;
pd[7491] = -(T_0*K_PTC_HH*maxPTC*HH_cell_2_side_3);
pd[10923] = T_0*0.166666666667/H_HH;
pd[13035] = T_0*LMxfer_HH;
pd[13167] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_0;
pd[13299] = T_0*LMxfer_HH;
pd[6832] = -(T_0*K_PTC_HH*maxPTC*HH_cell_2_side_4);
pd[10924] = T_0*0.166666666667/H_HH;
pd[13168] = T_0*LMxfer_HH;
pd[13300] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_1;
pd[13432] = T_0*LMxfer_HH;
pd[6965] = -(T_0*K_PTC_HH*maxPTC*HH_cell_2_side_5);
pd[10925] = T_0*0.166666666667/H_HH;
pd[12773] = T_0*LMxfer_HH;
pd[13301] = T_0*LMxfer_HH;
pd[13433] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_1_side_2;
pd[8682] = -(T_0*K_PTC_HH*maxPTC*HH_cell_3_side_0);
pd[11058] = T_0*0.166666666667/H_HH;
pd[13566] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_3;
pd[13698] = T_0*LMxfer_HH;
pd[14226] = T_0*LMxfer_HH;
pd[6439] = -(T_0*K_PTC_HH*maxPTC*HH_cell_3_side_1);
pd[11059] = T_0*0.166666666667/H_HH;
pd[13567] = T_0*LMxfer_HH;
pd[13699] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_4;
pd[13831] = T_0*LMxfer_HH;
pd[6572] = -(T_0*K_PTC_HH*maxPTC*HH_cell_3_side_2);
pd[11060] = T_0*0.166666666667/H_HH;
pd[13700] = T_0*LMxfer_HH;
pd[13832] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_0_side_5;
pd[13964] = T_0*LMxfer_HH;
pd[8289] = -(T_0*K_PTC_HH*maxPTC*HH_cell_3_side_3);
pd[11061] = T_0*0.166666666667/H_HH;
pd[13833] = T_0*LMxfer_HH;
pd[13965] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_3_side_0;
pd[14097] = T_0*LMxfer_HH;
pd[7630] = -(T_0*K_PTC_HH*maxPTC*HH_cell_3_side_4);
pd[11062] = T_0*0.166666666667/H_HH;
pd[13966] = T_0*LMxfer_HH;
pd[14098] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_1;
pd[14230] = T_0*LMxfer_HH;
pd[7763] = -(T_0*K_PTC_HH*maxPTC*HH_cell_3_side_5);
pd[11063] = T_0*0.166666666667/H_HH;
pd[13571] = T_0*LMxfer_HH;
pd[14099] = T_0*LMxfer_HH;
pd[14231] = -(T_0/H_HH) - T_0*LMxfer_HH*2.0 - T_0*K_PTC_HH*maxPTC*PTC_cell_2_side_2;
pd[5916] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_3;
pd[11592] = T_0*K_PTC_HH*maxHH*PTC_cell_0_side_0;
pd[14364] = -(T_0/H_PH);
pd[6049] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_4;
pd[12517] = T_0*K_PTC_HH*maxHH*PTC_cell_0_side_1;
pd[14497] = -(T_0/H_PH);
pd[6182] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_5;
pd[12650] = T_0*K_PTC_HH*maxHH*PTC_cell_0_side_2;
pd[14630] = -(T_0/H_PH);
pd[6315] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_0;
pd[11199] = T_0*K_PTC_HH*maxHH*PTC_cell_0_side_3;
pd[14763] = -(T_0/H_PH);
pd[6448] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_1;
pd[13708] = T_0*K_PTC_HH*maxHH*PTC_cell_0_side_4;
pd[14896] = -(T_0/H_PH);
pd[6581] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_2;
pd[13841] = T_0*K_PTC_HH*maxHH*PTC_cell_0_side_5;
pd[15029] = -(T_0/H_PH);
pd[6714] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_3;
pd[12390] = T_0*K_PTC_HH*maxHH*PTC_cell_1_side_0;
pd[15162] = -(T_0/H_PH);
pd[6847] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_4;
pd[13315] = T_0*K_PTC_HH*maxHH*PTC_cell_1_side_1;
pd[15295] = -(T_0/H_PH);
pd[6980] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_5;
pd[13448] = T_0*K_PTC_HH*maxHH*PTC_cell_1_side_2;
pd[15428] = -(T_0/H_PH);
pd[7113] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_0;
pd[11997] = T_0*K_PTC_HH*maxHH*PTC_cell_1_side_3;
pd[15561] = -(T_0/H_PH);
pd[7246] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_1;
pd[11338] = T_0*K_PTC_HH*maxHH*PTC_cell_1_side_4;
pd[15694] = -(T_0/H_PH);
pd[7379] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_2;
pd[11471] = T_0*K_PTC_HH*maxHH*PTC_cell_1_side_5;
pd[15827] = -(T_0/H_PH);
pd[7512] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_3;
pd[13188] = T_0*K_PTC_HH*maxHH*PTC_cell_2_side_0;
pd[15960] = -(T_0/H_PH);
pd[7645] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_4;
pd[14113] = T_0*K_PTC_HH*maxHH*PTC_cell_2_side_1;
pd[16093] = -(T_0/H_PH);
pd[7778] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_5;
pd[14246] = T_0*K_PTC_HH*maxHH*PTC_cell_2_side_2;
pd[16226] = -(T_0/H_PH);
pd[7911] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_0;
pd[12795] = T_0*K_PTC_HH*maxHH*PTC_cell_2_side_3;
pd[16359] = -(T_0/H_PH);
pd[8044] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_1;
pd[12136] = T_0*K_PTC_HH*maxHH*PTC_cell_2_side_4;
pd[16492] = -(T_0/H_PH);
pd[8177] = T_0*K_PTC_HH*maxHH*HH_cell_1_side_2;
pd[12269] = T_0*K_PTC_HH*maxHH*PTC_cell_2_side_5;
pd[16625] = -(T_0/H_PH);
pd[8310] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_3;
pd[13986] = T_0*K_PTC_HH*maxHH*PTC_cell_3_side_0;
pd[16758] = -(T_0/H_PH);
pd[8443] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_4;
pd[11743] = T_0*K_PTC_HH*maxHH*PTC_cell_3_side_1;
pd[16891] = -(T_0/H_PH);
pd[8576] = T_0*K_PTC_HH*maxHH*HH_cell_0_side_5;
pd[11876] = T_0*K_PTC_HH*maxHH*PTC_cell_3_side_2;
pd[17024] = -(T_0/H_PH);
pd[8709] = T_0*K_PTC_HH*maxHH*HH_cell_3_side_0;
pd[13593] = T_0*K_PTC_HH*maxHH*PTC_cell_3_side_3;
pd[17157] = -(T_0/H_PH);
pd[8842] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_1;
pd[12934] = T_0*K_PTC_HH*maxHH*PTC_cell_3_side_4;
pd[17290] = -(T_0/H_PH);
pd[8975] = T_0*K_PTC_HH*maxHH*HH_cell_2_side_2;
pd[13067] = T_0*K_PTC_HH*maxHH*PTC_cell_3_side_5;
pd[17423] = -(T_0/H_PH);
}

void dres_dcdot_function_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = -1;
pd[133] = -1;
pd[266] = -1;
pd[399] = -1;
pd[532] = -1;
pd[665] = -1;
pd[798] = -1;
pd[931] = -1;
pd[1064] = -1;
pd[1197] = -1;
pd[1330] = -1;
pd[1463] = -1;
pd[1596] = -1;
pd[1729] = -1;
pd[1862] = -1;
pd[1995] = -1;
pd[2128] = -1;
pd[2261] = -1;
pd[2394] = -1;
pd[2527] = -1;
pd[2660] = -1;
pd[2793] = -1;
pd[2926] = -1;
pd[3059] = -1;
pd[3192] = -1;
pd[3325] = -1;
pd[3458] = -1;
pd[3591] = -1;
pd[3724] = -1;
pd[3857] = -1;
pd[3990] = -1;
pd[4123] = -1;
pd[4256] = -1;
pd[4389] = -1;
pd[4522] = -1;
pd[4655] = -1;
pd[4788] = -1;
pd[4921] = -1;
pd[5054] = -1;
pd[5187] = -1;
pd[5320] = -1;
pd[5453] = -1;
pd[5586] = -1;
pd[5719] = -1;
pd[5852] = -1;
pd[5985] = -1;
pd[6118] = -1;
pd[6251] = -1;
pd[6384] = -1;
pd[6517] = -1;
pd[6650] = -1;
pd[6783] = -1;
pd[6916] = -1;
pd[7049] = -1;
pd[7182] = -1;
pd[7315] = -1;
pd[7448] = -1;
pd[7581] = -1;
pd[7714] = -1;
pd[7847] = -1;
pd[7980] = -1;
pd[8113] = -1;
pd[8246] = -1;
pd[8379] = -1;
pd[8512] = -1;
pd[8645] = -1;
pd[8778] = -1;
pd[8911] = -1;
pd[9044] = -1;
pd[9177] = -1;
pd[9310] = -1;
pd[9443] = -1;
pd[9576] = -1;
pd[9709] = -1;
pd[9842] = -1;
pd[9975] = -1;
pd[10108] = -1;
pd[10241] = -1;
pd[10374] = -1;
pd[10507] = -1;
pd[10640] = -1;
pd[10773] = -1;
pd[10906] = -1;
pd[11039] = -1;
pd[11172] = -1;
pd[11305] = -1;
pd[11438] = -1;
pd[11571] = -1;
pd[11704] = -1;
pd[11837] = -1;
pd[11970] = -1;
pd[12103] = -1;
pd[12236] = -1;
pd[12369] = -1;
pd[12502] = -1;
pd[12635] = -1;
pd[12768] = -1;
pd[12901] = -1;
pd[13034] = -1;
pd[13167] = -1;
pd[13300] = -1;
pd[13433] = -1;
pd[13566] = -1;
pd[13699] = -1;
pd[13832] = -1;
pd[13965] = -1;
pd[14098] = -1;
pd[14231] = -1;
pd[14364] = -1;
pd[14497] = -1;
pd[14630] = -1;
pd[14763] = -1;
pd[14896] = -1;
pd[15029] = -1;
pd[15162] = -1;
pd[15295] = -1;
pd[15428] = -1;
pd[15561] = -1;
pd[15694] = -1;
pd[15827] = -1;
pd[15960] = -1;
pd[16093] = -1;
pd[16226] = -1;
pd[16359] = -1;
pd[16492] = -1;
pd[16625] = -1;
pd[16758] = -1;
pd[16891] = -1;
pd[17024] = -1;
pd[17157] = -1;
pd[17290] = -1;
pd[17423] = -1;
}

void ddaskr_jac_(double *time_ptr, double *dynamicVars, double *yprime, double *pd, double *cj_ptr, double *constants, int *intpar){
double cj = *cj_ptr;

dres_dc_function_(time_ptr, dynamicVars, yprime, constants, pd);

double dres_dcdot[132*132] = {0};
dres_dcdot_function_(time_ptr, dynamicVars, yprime, constants, dres_dcdot);

int ii;
for(ii=0; ii < 17424; ii++){
  pd[ii] += cj*dres_dcdot[ii];}
}

void dres_dK_WGen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = T_0*phi_1(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
pd[1] = T_0*phi_1(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
pd[2] = T_0*phi_1(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
pd[3] = T_0*phi_1(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
}

void dres_dK_CNen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_0*psi_1(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[1] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_1*psi_1(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[2] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_2*psi_1(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[3] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_3*psi_1(CN_cell_3, K_CNen, nu_CNen)/H_en;
}

void dres_dK_WGwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*alpha_wg*phi_1(IWG_cell_0, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_1(IWG_cell_0, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*alpha_wg*phi_1(IWG_cell_1, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_1(IWG_cell_1, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*alpha_wg*phi_1(IWG_cell_2, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_1(IWG_cell_2, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*alpha_wg*phi_1(IWG_cell_3, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_1(IWG_cell_3, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dK_CIDwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*beta_wg*phi_1(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_1(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*beta_wg*phi_1(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_1(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*beta_wg*phi_1(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_1(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*beta_wg*phi_1(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_1(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dK_CNwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_0*psi_1(CN_cell_0, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_0*psi_1(CN_cell_0, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_1*psi_1(CN_cell_1, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_1*psi_1(CN_cell_1, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_2*psi_1(CN_cell_2, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_2*psi_1(CN_cell_2, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_3*psi_1(CN_cell_3, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_3*psi_1(CN_cell_3, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dK_CIDptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[40] = T_0*phi_1(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
pd[41] = T_0*phi_1(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
pd[42] = T_0*phi_1(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
pd[43] = T_0*phi_1(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
}

void dres_dK_CNptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[40] = T_0*phi_0(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_0*psi_1(CN_cell_0, K_CNptc, nu_CNptc)/H_ptc;
pd[41] = T_0*phi_0(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_1*psi_1(CN_cell_1, K_CNptc, nu_CNptc)/H_ptc;
pd[42] = T_0*phi_0(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_2*psi_1(CN_cell_2, K_CNptc, nu_CNptc)/H_ptc;
pd[43] = T_0*phi_0(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_3*psi_1(CN_cell_3, K_CNptc, nu_CNptc)/H_ptc;
}

void dres_dK_Bcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[68] = T_0*phi_1(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
pd[69] = T_0*phi_1(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
pd[70] = T_0*phi_1(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
pd[71] = T_0*phi_1(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
}

void dres_dK_ENcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[68] = T_0*phi_0(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_0*psi_1(EN_cell_0, K_ENcid, nu_ENcid)/H_cid;
pd[69] = T_0*phi_0(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_1*psi_1(EN_cell_1, K_ENcid, nu_ENcid)/H_cid;
pd[70] = T_0*phi_0(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_2*psi_1(EN_cell_2, K_ENcid, nu_ENcid)/H_cid;
pd[71] = T_0*phi_0(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_3*psi_1(EN_cell_3, K_ENcid, nu_ENcid)/H_cid;
}

void dres_dK_PTCCID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[72] = -(T_0*C_CID*CID_cell_0*phi_1(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[73] = -(T_0*C_CID*CID_cell_1*phi_1(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[74] = -(T_0*C_CID*CID_cell_2*phi_1(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[75] = -(T_0*C_CID*CID_cell_3*phi_1(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[76] = T_0*C_CID*CID_cell_0*phi_1(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[77] = T_0*C_CID*CID_cell_1*phi_1(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[78] = T_0*C_CID*CID_cell_2*phi_1(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[79] = T_0*C_CID*CID_cell_3*phi_1(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
}

void dres_dK_ENhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[80] = T_0*phi_1(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
pd[81] = T_0*phi_1(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
pd[82] = T_0*phi_1(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
pd[83] = T_0*phi_1(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
}

void dres_dK_CNhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[80] = T_0*phi_0(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_0*psi_1(CN_cell_0, K_CNhh, nu_CNhh)/H_hh;
pd[81] = T_0*phi_0(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_1*psi_1(CN_cell_1, K_CNhh, nu_CNhh)/H_hh;
pd[82] = T_0*phi_0(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_2*psi_1(CN_cell_2, K_CNhh, nu_CNhh)/H_hh;
pd[83] = T_0*phi_0(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_3*psi_1(CN_cell_3, K_CNhh, nu_CNhh)/H_hh;
}

void dres_dK_PTC_HH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[44] = -(T_0*maxHH*HH_cell_0_side_3*PTC_cell_0_side_0);
pd[45] = -(T_0*maxHH*HH_cell_1_side_4*PTC_cell_0_side_1);
pd[46] = -(T_0*maxHH*HH_cell_1_side_5*PTC_cell_0_side_2);
pd[47] = -(T_0*maxHH*HH_cell_0_side_0*PTC_cell_0_side_3);
pd[48] = -(T_0*maxHH*HH_cell_3_side_1*PTC_cell_0_side_4);
pd[49] = -(T_0*maxHH*HH_cell_3_side_2*PTC_cell_0_side_5);
pd[50] = -(T_0*maxHH*HH_cell_1_side_3*PTC_cell_1_side_0);
pd[51] = -(T_0*maxHH*HH_cell_2_side_4*PTC_cell_1_side_1);
pd[52] = -(T_0*maxHH*HH_cell_2_side_5*PTC_cell_1_side_2);
pd[53] = -(T_0*maxHH*HH_cell_1_side_0*PTC_cell_1_side_3);
pd[54] = -(T_0*maxHH*HH_cell_0_side_1*PTC_cell_1_side_4);
pd[55] = -(T_0*maxHH*HH_cell_0_side_2*PTC_cell_1_side_5);
pd[56] = -(T_0*maxHH*HH_cell_2_side_3*PTC_cell_2_side_0);
pd[57] = -(T_0*maxHH*HH_cell_3_side_4*PTC_cell_2_side_1);
pd[58] = -(T_0*maxHH*HH_cell_3_side_5*PTC_cell_2_side_2);
pd[59] = -(T_0*maxHH*HH_cell_2_side_0*PTC_cell_2_side_3);
pd[60] = -(T_0*maxHH*HH_cell_1_side_1*PTC_cell_2_side_4);
pd[61] = -(T_0*maxHH*HH_cell_1_side_2*PTC_cell_2_side_5);
pd[62] = -(T_0*maxHH*HH_cell_3_side_3*PTC_cell_3_side_0);
pd[63] = -(T_0*maxHH*HH_cell_0_side_4*PTC_cell_3_side_1);
pd[64] = -(T_0*maxHH*HH_cell_0_side_5*PTC_cell_3_side_2);
pd[65] = -(T_0*maxHH*HH_cell_3_side_0*PTC_cell_3_side_3);
pd[66] = -(T_0*maxHH*HH_cell_2_side_1*PTC_cell_3_side_4);
pd[67] = -(T_0*maxHH*HH_cell_2_side_2*PTC_cell_3_side_5);
pd[84] = -(T_0*maxPTC*PTC_cell_0_side_3*HH_cell_0_side_0);
pd[85] = -(T_0*maxPTC*PTC_cell_1_side_4*HH_cell_0_side_1);
pd[86] = -(T_0*maxPTC*PTC_cell_1_side_5*HH_cell_0_side_2);
pd[87] = -(T_0*maxPTC*PTC_cell_0_side_0*HH_cell_0_side_3);
pd[88] = -(T_0*maxPTC*PTC_cell_3_side_1*HH_cell_0_side_4);
pd[89] = -(T_0*maxPTC*PTC_cell_3_side_2*HH_cell_0_side_5);
pd[90] = -(T_0*maxPTC*PTC_cell_1_side_3*HH_cell_1_side_0);
pd[91] = -(T_0*maxPTC*PTC_cell_2_side_4*HH_cell_1_side_1);
pd[92] = -(T_0*maxPTC*PTC_cell_2_side_5*HH_cell_1_side_2);
pd[93] = -(T_0*maxPTC*PTC_cell_1_side_0*HH_cell_1_side_3);
pd[94] = -(T_0*maxPTC*PTC_cell_0_side_1*HH_cell_1_side_4);
pd[95] = -(T_0*maxPTC*PTC_cell_0_side_2*HH_cell_1_side_5);
pd[96] = -(T_0*maxPTC*PTC_cell_2_side_3*HH_cell_2_side_0);
pd[97] = -(T_0*maxPTC*PTC_cell_3_side_4*HH_cell_2_side_1);
pd[98] = -(T_0*maxPTC*PTC_cell_3_side_5*HH_cell_2_side_2);
pd[99] = -(T_0*maxPTC*PTC_cell_2_side_0*HH_cell_2_side_3);
pd[100] = -(T_0*maxPTC*PTC_cell_1_side_1*HH_cell_2_side_4);
pd[101] = -(T_0*maxPTC*PTC_cell_1_side_2*HH_cell_2_side_5);
pd[102] = -(T_0*maxPTC*PTC_cell_3_side_3*HH_cell_3_side_0);
pd[103] = -(T_0*maxPTC*PTC_cell_0_side_4*HH_cell_3_side_1);
pd[104] = -(T_0*maxPTC*PTC_cell_0_side_5*HH_cell_3_side_2);
pd[105] = -(T_0*maxPTC*PTC_cell_3_side_0*HH_cell_3_side_3);
pd[106] = -(T_0*maxPTC*PTC_cell_2_side_1*HH_cell_3_side_4);
pd[107] = -(T_0*maxPTC*PTC_cell_2_side_2*HH_cell_3_side_5);
pd[108] = T_0*maxHH*HH_cell_0_side_3*PTC_cell_0_side_0;
pd[109] = T_0*maxHH*HH_cell_1_side_4*PTC_cell_0_side_1;
pd[110] = T_0*maxHH*HH_cell_1_side_5*PTC_cell_0_side_2;
pd[111] = T_0*maxHH*HH_cell_0_side_0*PTC_cell_0_side_3;
pd[112] = T_0*maxHH*HH_cell_3_side_1*PTC_cell_0_side_4;
pd[113] = T_0*maxHH*HH_cell_3_side_2*PTC_cell_0_side_5;
pd[114] = T_0*maxHH*HH_cell_1_side_3*PTC_cell_1_side_0;
pd[115] = T_0*maxHH*HH_cell_2_side_4*PTC_cell_1_side_1;
pd[116] = T_0*maxHH*HH_cell_2_side_5*PTC_cell_1_side_2;
pd[117] = T_0*maxHH*HH_cell_1_side_0*PTC_cell_1_side_3;
pd[118] = T_0*maxHH*HH_cell_0_side_1*PTC_cell_1_side_4;
pd[119] = T_0*maxHH*HH_cell_0_side_2*PTC_cell_1_side_5;
pd[120] = T_0*maxHH*HH_cell_2_side_3*PTC_cell_2_side_0;
pd[121] = T_0*maxHH*HH_cell_3_side_4*PTC_cell_2_side_1;
pd[122] = T_0*maxHH*HH_cell_3_side_5*PTC_cell_2_side_2;
pd[123] = T_0*maxHH*HH_cell_2_side_0*PTC_cell_2_side_3;
pd[124] = T_0*maxHH*HH_cell_1_side_1*PTC_cell_2_side_4;
pd[125] = T_0*maxHH*HH_cell_1_side_2*PTC_cell_2_side_5;
pd[126] = T_0*maxHH*HH_cell_3_side_3*PTC_cell_3_side_0;
pd[127] = T_0*maxHH*HH_cell_0_side_4*PTC_cell_3_side_1;
pd[128] = T_0*maxHH*HH_cell_0_side_5*PTC_cell_3_side_2;
pd[129] = T_0*maxHH*HH_cell_3_side_0*PTC_cell_3_side_3;
pd[130] = T_0*maxHH*HH_cell_2_side_1*PTC_cell_3_side_4;
pd[131] = T_0*maxHH*HH_cell_2_side_2*PTC_cell_3_side_5;
}

void dres_dmaxPTC_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[84] = -(T_0*K_PTC_HH*PTC_cell_0_side_3*HH_cell_0_side_0);
pd[85] = -(T_0*K_PTC_HH*PTC_cell_1_side_4*HH_cell_0_side_1);
pd[86] = -(T_0*K_PTC_HH*PTC_cell_1_side_5*HH_cell_0_side_2);
pd[87] = -(T_0*K_PTC_HH*PTC_cell_0_side_0*HH_cell_0_side_3);
pd[88] = -(T_0*K_PTC_HH*PTC_cell_3_side_1*HH_cell_0_side_4);
pd[89] = -(T_0*K_PTC_HH*PTC_cell_3_side_2*HH_cell_0_side_5);
pd[90] = -(T_0*K_PTC_HH*PTC_cell_1_side_3*HH_cell_1_side_0);
pd[91] = -(T_0*K_PTC_HH*PTC_cell_2_side_4*HH_cell_1_side_1);
pd[92] = -(T_0*K_PTC_HH*PTC_cell_2_side_5*HH_cell_1_side_2);
pd[93] = -(T_0*K_PTC_HH*PTC_cell_1_side_0*HH_cell_1_side_3);
pd[94] = -(T_0*K_PTC_HH*PTC_cell_0_side_1*HH_cell_1_side_4);
pd[95] = -(T_0*K_PTC_HH*PTC_cell_0_side_2*HH_cell_1_side_5);
pd[96] = -(T_0*K_PTC_HH*PTC_cell_2_side_3*HH_cell_2_side_0);
pd[97] = -(T_0*K_PTC_HH*PTC_cell_3_side_4*HH_cell_2_side_1);
pd[98] = -(T_0*K_PTC_HH*PTC_cell_3_side_5*HH_cell_2_side_2);
pd[99] = -(T_0*K_PTC_HH*PTC_cell_2_side_0*HH_cell_2_side_3);
pd[100] = -(T_0*K_PTC_HH*PTC_cell_1_side_1*HH_cell_2_side_4);
pd[101] = -(T_0*K_PTC_HH*PTC_cell_1_side_2*HH_cell_2_side_5);
pd[102] = -(T_0*K_PTC_HH*PTC_cell_3_side_3*HH_cell_3_side_0);
pd[103] = -(T_0*K_PTC_HH*PTC_cell_0_side_4*HH_cell_3_side_1);
pd[104] = -(T_0*K_PTC_HH*PTC_cell_0_side_5*HH_cell_3_side_2);
pd[105] = -(T_0*K_PTC_HH*PTC_cell_3_side_0*HH_cell_3_side_3);
pd[106] = -(T_0*K_PTC_HH*PTC_cell_2_side_1*HH_cell_3_side_4);
pd[107] = -(T_0*K_PTC_HH*PTC_cell_2_side_2*HH_cell_3_side_5);
}

void dres_dmaxHH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[44] = -(T_0*K_PTC_HH*HH_cell_0_side_3*PTC_cell_0_side_0);
pd[45] = -(T_0*K_PTC_HH*HH_cell_1_side_4*PTC_cell_0_side_1);
pd[46] = -(T_0*K_PTC_HH*HH_cell_1_side_5*PTC_cell_0_side_2);
pd[47] = -(T_0*K_PTC_HH*HH_cell_0_side_0*PTC_cell_0_side_3);
pd[48] = -(T_0*K_PTC_HH*HH_cell_3_side_1*PTC_cell_0_side_4);
pd[49] = -(T_0*K_PTC_HH*HH_cell_3_side_2*PTC_cell_0_side_5);
pd[50] = -(T_0*K_PTC_HH*HH_cell_1_side_3*PTC_cell_1_side_0);
pd[51] = -(T_0*K_PTC_HH*HH_cell_2_side_4*PTC_cell_1_side_1);
pd[52] = -(T_0*K_PTC_HH*HH_cell_2_side_5*PTC_cell_1_side_2);
pd[53] = -(T_0*K_PTC_HH*HH_cell_1_side_0*PTC_cell_1_side_3);
pd[54] = -(T_0*K_PTC_HH*HH_cell_0_side_1*PTC_cell_1_side_4);
pd[55] = -(T_0*K_PTC_HH*HH_cell_0_side_2*PTC_cell_1_side_5);
pd[56] = -(T_0*K_PTC_HH*HH_cell_2_side_3*PTC_cell_2_side_0);
pd[57] = -(T_0*K_PTC_HH*HH_cell_3_side_4*PTC_cell_2_side_1);
pd[58] = -(T_0*K_PTC_HH*HH_cell_3_side_5*PTC_cell_2_side_2);
pd[59] = -(T_0*K_PTC_HH*HH_cell_2_side_0*PTC_cell_2_side_3);
pd[60] = -(T_0*K_PTC_HH*HH_cell_1_side_1*PTC_cell_2_side_4);
pd[61] = -(T_0*K_PTC_HH*HH_cell_1_side_2*PTC_cell_2_side_5);
pd[62] = -(T_0*K_PTC_HH*HH_cell_3_side_3*PTC_cell_3_side_0);
pd[63] = -(T_0*K_PTC_HH*HH_cell_0_side_4*PTC_cell_3_side_1);
pd[64] = -(T_0*K_PTC_HH*HH_cell_0_side_5*PTC_cell_3_side_2);
pd[65] = -(T_0*K_PTC_HH*HH_cell_3_side_0*PTC_cell_3_side_3);
pd[66] = -(T_0*K_PTC_HH*HH_cell_2_side_1*PTC_cell_3_side_4);
pd[67] = -(T_0*K_PTC_HH*HH_cell_2_side_2*PTC_cell_3_side_5);
pd[108] = T_0*K_PTC_HH*HH_cell_0_side_3*PTC_cell_0_side_0;
pd[109] = T_0*K_PTC_HH*HH_cell_1_side_4*PTC_cell_0_side_1;
pd[110] = T_0*K_PTC_HH*HH_cell_1_side_5*PTC_cell_0_side_2;
pd[111] = T_0*K_PTC_HH*HH_cell_0_side_0*PTC_cell_0_side_3;
pd[112] = T_0*K_PTC_HH*HH_cell_3_side_1*PTC_cell_0_side_4;
pd[113] = T_0*K_PTC_HH*HH_cell_3_side_2*PTC_cell_0_side_5;
pd[114] = T_0*K_PTC_HH*HH_cell_1_side_3*PTC_cell_1_side_0;
pd[115] = T_0*K_PTC_HH*HH_cell_2_side_4*PTC_cell_1_side_1;
pd[116] = T_0*K_PTC_HH*HH_cell_2_side_5*PTC_cell_1_side_2;
pd[117] = T_0*K_PTC_HH*HH_cell_1_side_0*PTC_cell_1_side_3;
pd[118] = T_0*K_PTC_HH*HH_cell_0_side_1*PTC_cell_1_side_4;
pd[119] = T_0*K_PTC_HH*HH_cell_0_side_2*PTC_cell_1_side_5;
pd[120] = T_0*K_PTC_HH*HH_cell_2_side_3*PTC_cell_2_side_0;
pd[121] = T_0*K_PTC_HH*HH_cell_3_side_4*PTC_cell_2_side_1;
pd[122] = T_0*K_PTC_HH*HH_cell_3_side_5*PTC_cell_2_side_2;
pd[123] = T_0*K_PTC_HH*HH_cell_2_side_0*PTC_cell_2_side_3;
pd[124] = T_0*K_PTC_HH*HH_cell_1_side_1*PTC_cell_2_side_4;
pd[125] = T_0*K_PTC_HH*HH_cell_1_side_2*PTC_cell_2_side_5;
pd[126] = T_0*K_PTC_HH*HH_cell_3_side_3*PTC_cell_3_side_0;
pd[127] = T_0*K_PTC_HH*HH_cell_0_side_4*PTC_cell_3_side_1;
pd[128] = T_0*K_PTC_HH*HH_cell_0_side_5*PTC_cell_3_side_2;
pd[129] = T_0*K_PTC_HH*HH_cell_3_side_0*PTC_cell_3_side_3;
pd[130] = T_0*K_PTC_HH*HH_cell_2_side_1*PTC_cell_3_side_4;
pd[131] = T_0*K_PTC_HH*HH_cell_2_side_2*PTC_cell_3_side_5;
}

void dres_dC_CID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[72] = -(T_0*CID_cell_0*phi(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[73] = -(T_0*CID_cell_1*phi(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[74] = -(T_0*CID_cell_2*phi(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[75] = -(T_0*CID_cell_3*phi(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[76] = T_0*CID_cell_0*phi(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[77] = T_0*CID_cell_1*phi(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[78] = T_0*CID_cell_2*phi(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[79] = T_0*CID_cell_3*phi(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
}

void dres_dnu_WGen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = T_0*phi_2(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
pd[1] = T_0*phi_2(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
pd[2] = T_0*phi_2(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
pd[3] = T_0*phi_2(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)/H_en;
}

void dres_dnu_CNen_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = T_0*phi_0(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_0*psi_2(CN_cell_0, K_CNen, nu_CNen)/H_en;
pd[1] = T_0*phi_0(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_1*psi_2(CN_cell_1, K_CNen, nu_CNen)/H_en;
pd[2] = T_0*phi_0(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_2*psi_2(CN_cell_2, K_CNen, nu_CNen)/H_en;
pd[3] = T_0*phi_0(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen)*EWG_tot_pres_cell_3*psi_2(CN_cell_3, K_CNen, nu_CNen)/H_en;
}

void dres_dnu_WGwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*alpha_wg*phi_2(IWG_cell_0, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_2(IWG_cell_0, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*alpha_wg*phi_2(IWG_cell_1, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_2(IWG_cell_1, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*alpha_wg*phi_2(IWG_cell_2, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_2(IWG_cell_2, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*alpha_wg*phi_2(IWG_cell_3, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*alpha_wg*phi_2(IWG_cell_3, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dnu_CIDwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*beta_wg*phi_2(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_2(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*beta_wg*phi_2(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_2(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*beta_wg*phi_2(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_2(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*beta_wg*phi_2(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_2(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dnu_CNwg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_0*psi_2(CN_cell_0, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_0*psi_2(CN_cell_0, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_1*psi_2(CN_cell_1, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_1*psi_2(CN_cell_1, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_2*psi_2(CN_cell_2, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_2*psi_2(CN_cell_2, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_3*psi_2(CN_cell_3, K_CNwg, nu_CNwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*beta_wg*phi_0(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)*CID_cell_3*psi_2(CN_cell_3, K_CNwg, nu_CNwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dnu_CIDptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[40] = T_0*phi_2(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
pd[41] = T_0*phi_2(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
pd[42] = T_0*phi_2(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
pd[43] = T_0*phi_2(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)/H_ptc;
}

void dres_dnu_CNptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[40] = T_0*phi_0(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_0*psi_2(CN_cell_0, K_CNptc, nu_CNptc)/H_ptc;
pd[41] = T_0*phi_0(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_1*psi_2(CN_cell_1, K_CNptc, nu_CNptc)/H_ptc;
pd[42] = T_0*phi_0(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_2*psi_2(CN_cell_2, K_CNptc, nu_CNptc)/H_ptc;
pd[43] = T_0*phi_0(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc)*CID_cell_3*psi_2(CN_cell_3, K_CNptc, nu_CNptc)/H_ptc;
}

void dres_dnu_Bcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[68] = T_0*phi_2(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
pd[69] = T_0*phi_2(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
pd[70] = T_0*phi_2(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
pd[71] = T_0*phi_2(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)/H_cid;
}

void dres_dnu_ENcid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[68] = T_0*phi_0(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_0*psi_2(EN_cell_0, K_ENcid, nu_ENcid)/H_cid;
pd[69] = T_0*phi_0(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_1*psi_2(EN_cell_1, K_ENcid, nu_ENcid)/H_cid;
pd[70] = T_0*phi_0(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_2*psi_2(EN_cell_2, K_ENcid, nu_ENcid)/H_cid;
pd[71] = T_0*phi_0(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid)*B_cell_3*psi_2(EN_cell_3, K_ENcid, nu_ENcid)/H_cid;
}

void dres_dnu_PTCCID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[72] = -(T_0*C_CID*CID_cell_0*phi_2(PTC_tot_cell_0, K_PTCCID, nu_PTCCID));
pd[73] = -(T_0*C_CID*CID_cell_1*phi_2(PTC_tot_cell_1, K_PTCCID, nu_PTCCID));
pd[74] = -(T_0*C_CID*CID_cell_2*phi_2(PTC_tot_cell_2, K_PTCCID, nu_PTCCID));
pd[75] = -(T_0*C_CID*CID_cell_3*phi_2(PTC_tot_cell_3, K_PTCCID, nu_PTCCID));
pd[76] = T_0*C_CID*CID_cell_0*phi_2(PTC_tot_cell_0, K_PTCCID, nu_PTCCID);
pd[77] = T_0*C_CID*CID_cell_1*phi_2(PTC_tot_cell_1, K_PTCCID, nu_PTCCID);
pd[78] = T_0*C_CID*CID_cell_2*phi_2(PTC_tot_cell_2, K_PTCCID, nu_PTCCID);
pd[79] = T_0*C_CID*CID_cell_3*phi_2(PTC_tot_cell_3, K_PTCCID, nu_PTCCID);
}

void dres_dnu_ENhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[80] = T_0*phi_2(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
pd[81] = T_0*phi_2(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
pd[82] = T_0*phi_2(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
pd[83] = T_0*phi_2(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)/H_hh;
}

void dres_dnu_CNhh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[80] = T_0*phi_0(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_0*psi_2(CN_cell_0, K_CNhh, nu_CNhh)/H_hh;
pd[81] = T_0*phi_0(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_1*psi_2(CN_cell_1, K_CNhh, nu_CNhh)/H_hh;
pd[82] = T_0*phi_0(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_2*psi_2(CN_cell_2, K_CNhh, nu_CNhh)/H_hh;
pd[83] = T_0*phi_0(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh)*EN_cell_3*psi_2(CN_cell_3, K_CNhh, nu_CNhh)/H_hh;
}

void dres_dH_en_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[0] = -(T_0*(phi(EWG_tot_pres_cell_0*psi(CN_cell_0, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_0)/pow(H_en, 2.0));
pd[1] = -(T_0*(phi(EWG_tot_pres_cell_1*psi(CN_cell_1, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_1)/pow(H_en, 2.0));
pd[2] = -(T_0*(phi(EWG_tot_pres_cell_2*psi(CN_cell_2, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_2)/pow(H_en, 2.0));
pd[3] = -(T_0*(phi(EWG_tot_pres_cell_3*psi(CN_cell_3, K_CNen, nu_CNen), K_WGen, nu_WGen) - en_cell_3)/pow(H_en, 2.0));
}

void dres_dH_EN_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[4] = -(T_0*(en_cell_0 - EN_cell_0)/pow(H_EN, 2.0));
pd[5] = -(T_0*(en_cell_1 - EN_cell_1)/pow(H_EN, 2.0));
pd[6] = -(T_0*(en_cell_2 - EN_cell_2)/pow(H_EN, 2.0));
pd[7] = -(T_0*(en_cell_3 - EN_cell_3)/pow(H_EN, 2.0));
}

void dres_dH_wg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*wg_cell_0/pow(H_wg, 2.0) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*wg_cell_1/pow(H_wg, 2.0) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*wg_cell_2/pow(H_wg, 2.0) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*wg_cell_3/pow(H_wg, 2.0) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dH_IWG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[12] = -(T_0*(wg_cell_0 - IWG_cell_0)/pow(H_IWG, 2.0));
pd[13] = -(T_0*(wg_cell_1 - IWG_cell_1)/pow(H_IWG, 2.0));
pd[14] = -(T_0*(wg_cell_2 - IWG_cell_2)/pow(H_IWG, 2.0));
pd[15] = -(T_0*(wg_cell_3 - IWG_cell_3)/pow(H_IWG, 2.0));
}

void dres_dH_EWG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[16] = T_0*EWG_cell_0_side_0/pow(H_EWG, 2.0);
pd[17] = T_0*EWG_cell_0_side_1/pow(H_EWG, 2.0);
pd[18] = T_0*EWG_cell_0_side_2/pow(H_EWG, 2.0);
pd[19] = T_0*EWG_cell_0_side_3/pow(H_EWG, 2.0);
pd[20] = T_0*EWG_cell_0_side_4/pow(H_EWG, 2.0);
pd[21] = T_0*EWG_cell_0_side_5/pow(H_EWG, 2.0);
pd[22] = T_0*EWG_cell_1_side_0/pow(H_EWG, 2.0);
pd[23] = T_0*EWG_cell_1_side_1/pow(H_EWG, 2.0);
pd[24] = T_0*EWG_cell_1_side_2/pow(H_EWG, 2.0);
pd[25] = T_0*EWG_cell_1_side_3/pow(H_EWG, 2.0);
pd[26] = T_0*EWG_cell_1_side_4/pow(H_EWG, 2.0);
pd[27] = T_0*EWG_cell_1_side_5/pow(H_EWG, 2.0);
pd[28] = T_0*EWG_cell_2_side_0/pow(H_EWG, 2.0);
pd[29] = T_0*EWG_cell_2_side_1/pow(H_EWG, 2.0);
pd[30] = T_0*EWG_cell_2_side_2/pow(H_EWG, 2.0);
pd[31] = T_0*EWG_cell_2_side_3/pow(H_EWG, 2.0);
pd[32] = T_0*EWG_cell_2_side_4/pow(H_EWG, 2.0);
pd[33] = T_0*EWG_cell_2_side_5/pow(H_EWG, 2.0);
pd[34] = T_0*EWG_cell_3_side_0/pow(H_EWG, 2.0);
pd[35] = T_0*EWG_cell_3_side_1/pow(H_EWG, 2.0);
pd[36] = T_0*EWG_cell_3_side_2/pow(H_EWG, 2.0);
pd[37] = T_0*EWG_cell_3_side_3/pow(H_EWG, 2.0);
pd[38] = T_0*EWG_cell_3_side_4/pow(H_EWG, 2.0);
pd[39] = T_0*EWG_cell_3_side_5/pow(H_EWG, 2.0);
}

void dres_dH_ptc_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[40] = -(T_0*(phi(CID_cell_0*psi(CN_cell_0, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_0)/pow(H_ptc, 2.0));
pd[41] = -(T_0*(phi(CID_cell_1*psi(CN_cell_1, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_1)/pow(H_ptc, 2.0));
pd[42] = -(T_0*(phi(CID_cell_2*psi(CN_cell_2, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_2)/pow(H_ptc, 2.0));
pd[43] = -(T_0*(phi(CID_cell_3*psi(CN_cell_3, K_CNptc, nu_CNptc), K_CIDptc, nu_CIDptc) - ptc_cell_3)/pow(H_ptc, 2.0));
}

void dres_dH_PTC_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[44] = -(T_0*(ptc_cell_0*0.166666666667 - PTC_cell_0_side_0)/pow(H_PTC, 2.0));
pd[45] = -(T_0*(ptc_cell_0*0.166666666667 - PTC_cell_0_side_1)/pow(H_PTC, 2.0));
pd[46] = -(T_0*(ptc_cell_0*0.166666666667 - PTC_cell_0_side_2)/pow(H_PTC, 2.0));
pd[47] = -(T_0*(ptc_cell_0*0.166666666667 - PTC_cell_0_side_3)/pow(H_PTC, 2.0));
pd[48] = -(T_0*(ptc_cell_0*0.166666666667 - PTC_cell_0_side_4)/pow(H_PTC, 2.0));
pd[49] = -(T_0*(ptc_cell_0*0.166666666667 - PTC_cell_0_side_5)/pow(H_PTC, 2.0));
pd[50] = -(T_0*(ptc_cell_1*0.166666666667 - PTC_cell_1_side_0)/pow(H_PTC, 2.0));
pd[51] = -(T_0*(ptc_cell_1*0.166666666667 - PTC_cell_1_side_1)/pow(H_PTC, 2.0));
pd[52] = -(T_0*(ptc_cell_1*0.166666666667 - PTC_cell_1_side_2)/pow(H_PTC, 2.0));
pd[53] = -(T_0*(ptc_cell_1*0.166666666667 - PTC_cell_1_side_3)/pow(H_PTC, 2.0));
pd[54] = -(T_0*(ptc_cell_1*0.166666666667 - PTC_cell_1_side_4)/pow(H_PTC, 2.0));
pd[55] = -(T_0*(ptc_cell_1*0.166666666667 - PTC_cell_1_side_5)/pow(H_PTC, 2.0));
pd[56] = -(T_0*(ptc_cell_2*0.166666666667 - PTC_cell_2_side_0)/pow(H_PTC, 2.0));
pd[57] = -(T_0*(ptc_cell_2*0.166666666667 - PTC_cell_2_side_1)/pow(H_PTC, 2.0));
pd[58] = -(T_0*(ptc_cell_2*0.166666666667 - PTC_cell_2_side_2)/pow(H_PTC, 2.0));
pd[59] = -(T_0*(ptc_cell_2*0.166666666667 - PTC_cell_2_side_3)/pow(H_PTC, 2.0));
pd[60] = -(T_0*(ptc_cell_2*0.166666666667 - PTC_cell_2_side_4)/pow(H_PTC, 2.0));
pd[61] = -(T_0*(ptc_cell_2*0.166666666667 - PTC_cell_2_side_5)/pow(H_PTC, 2.0));
pd[62] = -(T_0*(ptc_cell_3*0.166666666667 - PTC_cell_3_side_0)/pow(H_PTC, 2.0));
pd[63] = -(T_0*(ptc_cell_3*0.166666666667 - PTC_cell_3_side_1)/pow(H_PTC, 2.0));
pd[64] = -(T_0*(ptc_cell_3*0.166666666667 - PTC_cell_3_side_2)/pow(H_PTC, 2.0));
pd[65] = -(T_0*(ptc_cell_3*0.166666666667 - PTC_cell_3_side_3)/pow(H_PTC, 2.0));
pd[66] = -(T_0*(ptc_cell_3*0.166666666667 - PTC_cell_3_side_4)/pow(H_PTC, 2.0));
pd[67] = -(T_0*(ptc_cell_3*0.166666666667 - PTC_cell_3_side_5)/pow(H_PTC, 2.0));
}

void dres_dH_cid_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[68] = -(T_0*(phi(B_cell_0*psi(EN_cell_0, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_0)/pow(H_cid, 2.0));
pd[69] = -(T_0*(phi(B_cell_1*psi(EN_cell_1, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_1)/pow(H_cid, 2.0));
pd[70] = -(T_0*(phi(B_cell_2*psi(EN_cell_2, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_2)/pow(H_cid, 2.0));
pd[71] = -(T_0*(phi(B_cell_3*psi(EN_cell_3, K_ENcid, nu_ENcid), K_Bcid, nu_Bcid) - cid_cell_3)/pow(H_cid, 2.0));
}

void dres_dH_CID_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[72] = -(T_0*(cid_cell_0 - CID_cell_0)/pow(H_CID, 2.0));
pd[73] = -(T_0*(cid_cell_1 - CID_cell_1)/pow(H_CID, 2.0));
pd[74] = -(T_0*(cid_cell_2 - CID_cell_2)/pow(H_CID, 2.0));
pd[75] = -(T_0*(cid_cell_3 - CID_cell_3)/pow(H_CID, 2.0));
}

void dres_dH_CN_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[76] = T_0*CN_cell_0/pow(H_CN, 2.0);
pd[77] = T_0*CN_cell_1/pow(H_CN, 2.0);
pd[78] = T_0*CN_cell_2/pow(H_CN, 2.0);
pd[79] = T_0*CN_cell_3/pow(H_CN, 2.0);
}

void dres_dH_hh_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[80] = -(T_0*(phi(EN_cell_0*psi(CN_cell_0, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_0)/pow(H_hh, 2.0));
pd[81] = -(T_0*(phi(EN_cell_1*psi(CN_cell_1, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_1)/pow(H_hh, 2.0));
pd[82] = -(T_0*(phi(EN_cell_2*psi(CN_cell_2, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_2)/pow(H_hh, 2.0));
pd[83] = -(T_0*(phi(EN_cell_3*psi(CN_cell_3, K_CNhh, nu_CNhh), K_ENhh, nu_ENhh) - hh_cell_3)/pow(H_hh, 2.0));
}

void dres_dH_HH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[84] = -(T_0*(hh_cell_0*0.166666666667 - HH_cell_0_side_0)/pow(H_HH, 2.0));
pd[85] = -(T_0*(hh_cell_0*0.166666666667 - HH_cell_0_side_1)/pow(H_HH, 2.0));
pd[86] = -(T_0*(hh_cell_0*0.166666666667 - HH_cell_0_side_2)/pow(H_HH, 2.0));
pd[87] = -(T_0*(hh_cell_0*0.166666666667 - HH_cell_0_side_3)/pow(H_HH, 2.0));
pd[88] = -(T_0*(hh_cell_0*0.166666666667 - HH_cell_0_side_4)/pow(H_HH, 2.0));
pd[89] = -(T_0*(hh_cell_0*0.166666666667 - HH_cell_0_side_5)/pow(H_HH, 2.0));
pd[90] = -(T_0*(hh_cell_1*0.166666666667 - HH_cell_1_side_0)/pow(H_HH, 2.0));
pd[91] = -(T_0*(hh_cell_1*0.166666666667 - HH_cell_1_side_1)/pow(H_HH, 2.0));
pd[92] = -(T_0*(hh_cell_1*0.166666666667 - HH_cell_1_side_2)/pow(H_HH, 2.0));
pd[93] = -(T_0*(hh_cell_1*0.166666666667 - HH_cell_1_side_3)/pow(H_HH, 2.0));
pd[94] = -(T_0*(hh_cell_1*0.166666666667 - HH_cell_1_side_4)/pow(H_HH, 2.0));
pd[95] = -(T_0*(hh_cell_1*0.166666666667 - HH_cell_1_side_5)/pow(H_HH, 2.0));
pd[96] = -(T_0*(hh_cell_2*0.166666666667 - HH_cell_2_side_0)/pow(H_HH, 2.0));
pd[97] = -(T_0*(hh_cell_2*0.166666666667 - HH_cell_2_side_1)/pow(H_HH, 2.0));
pd[98] = -(T_0*(hh_cell_2*0.166666666667 - HH_cell_2_side_2)/pow(H_HH, 2.0));
pd[99] = -(T_0*(hh_cell_2*0.166666666667 - HH_cell_2_side_3)/pow(H_HH, 2.0));
pd[100] = -(T_0*(hh_cell_2*0.166666666667 - HH_cell_2_side_4)/pow(H_HH, 2.0));
pd[101] = -(T_0*(hh_cell_2*0.166666666667 - HH_cell_2_side_5)/pow(H_HH, 2.0));
pd[102] = -(T_0*(hh_cell_3*0.166666666667 - HH_cell_3_side_0)/pow(H_HH, 2.0));
pd[103] = -(T_0*(hh_cell_3*0.166666666667 - HH_cell_3_side_1)/pow(H_HH, 2.0));
pd[104] = -(T_0*(hh_cell_3*0.166666666667 - HH_cell_3_side_2)/pow(H_HH, 2.0));
pd[105] = -(T_0*(hh_cell_3*0.166666666667 - HH_cell_3_side_3)/pow(H_HH, 2.0));
pd[106] = -(T_0*(hh_cell_3*0.166666666667 - HH_cell_3_side_4)/pow(H_HH, 2.0));
pd[107] = -(T_0*(hh_cell_3*0.166666666667 - HH_cell_3_side_5)/pow(H_HH, 2.0));
}

void dres_dH_PH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[108] = T_0*PH_cell_0_side_0/pow(H_PH, 2.0);
pd[109] = T_0*PH_cell_0_side_1/pow(H_PH, 2.0);
pd[110] = T_0*PH_cell_0_side_2/pow(H_PH, 2.0);
pd[111] = T_0*PH_cell_0_side_3/pow(H_PH, 2.0);
pd[112] = T_0*PH_cell_0_side_4/pow(H_PH, 2.0);
pd[113] = T_0*PH_cell_0_side_5/pow(H_PH, 2.0);
pd[114] = T_0*PH_cell_1_side_0/pow(H_PH, 2.0);
pd[115] = T_0*PH_cell_1_side_1/pow(H_PH, 2.0);
pd[116] = T_0*PH_cell_1_side_2/pow(H_PH, 2.0);
pd[117] = T_0*PH_cell_1_side_3/pow(H_PH, 2.0);
pd[118] = T_0*PH_cell_1_side_4/pow(H_PH, 2.0);
pd[119] = T_0*PH_cell_1_side_5/pow(H_PH, 2.0);
pd[120] = T_0*PH_cell_2_side_0/pow(H_PH, 2.0);
pd[121] = T_0*PH_cell_2_side_1/pow(H_PH, 2.0);
pd[122] = T_0*PH_cell_2_side_2/pow(H_PH, 2.0);
pd[123] = T_0*PH_cell_2_side_3/pow(H_PH, 2.0);
pd[124] = T_0*PH_cell_2_side_4/pow(H_PH, 2.0);
pd[125] = T_0*PH_cell_2_side_5/pow(H_PH, 2.0);
pd[126] = T_0*PH_cell_3_side_0/pow(H_PH, 2.0);
pd[127] = T_0*PH_cell_3_side_1/pow(H_PH, 2.0);
pd[128] = T_0*PH_cell_3_side_2/pow(H_PH, 2.0);
pd[129] = T_0*PH_cell_3_side_3/pow(H_PH, 2.0);
pd[130] = T_0*PH_cell_3_side_4/pow(H_PH, 2.0);
pd[131] = T_0*PH_cell_3_side_5/pow(H_PH, 2.0);
}

void dres_dalpha_wg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*phi(IWG_cell_0, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*phi(IWG_cell_1, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*phi(IWG_cell_2, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*phi(IWG_cell_3, K_WGwg, nu_WGwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dbeta_wg_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[8] = T_0*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg))*H_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_0*psi(CN_cell_0, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_0, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[9] = T_0*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg))*H_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_1*psi(CN_cell_1, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_1, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[10] = T_0*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg))*H_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_2*psi(CN_cell_2, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_2, K_WGwg, nu_WGwg) + 1.0), 2.0);
pd[11] = T_0*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0)) - T_0*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg))*H_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg)/pow(H_wg*(beta_wg*phi(CID_cell_3*psi(CN_cell_3, K_CNwg, nu_CNwg), K_CIDwg, nu_CIDwg) + alpha_wg*phi(IWG_cell_3, K_WGwg, nu_WGwg) + 1.0), 2.0);
}

void dres_dEndo_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[12] = T_0*EWG_tot_cell_0;
pd[13] = T_0*EWG_tot_cell_1;
pd[14] = T_0*EWG_tot_cell_2;
pd[15] = T_0*EWG_tot_cell_3;
pd[16] = -(T_0*EWG_cell_0_side_0);
pd[17] = -(T_0*EWG_cell_0_side_1);
pd[18] = -(T_0*EWG_cell_0_side_2);
pd[19] = -(T_0*EWG_cell_0_side_3);
pd[20] = -(T_0*EWG_cell_0_side_4);
pd[21] = -(T_0*EWG_cell_0_side_5);
pd[22] = -(T_0*EWG_cell_1_side_0);
pd[23] = -(T_0*EWG_cell_1_side_1);
pd[24] = -(T_0*EWG_cell_1_side_2);
pd[25] = -(T_0*EWG_cell_1_side_3);
pd[26] = -(T_0*EWG_cell_1_side_4);
pd[27] = -(T_0*EWG_cell_1_side_5);
pd[28] = -(T_0*EWG_cell_2_side_0);
pd[29] = -(T_0*EWG_cell_2_side_1);
pd[30] = -(T_0*EWG_cell_2_side_2);
pd[31] = -(T_0*EWG_cell_2_side_3);
pd[32] = -(T_0*EWG_cell_2_side_4);
pd[33] = -(T_0*EWG_cell_2_side_5);
pd[34] = -(T_0*EWG_cell_3_side_0);
pd[35] = -(T_0*EWG_cell_3_side_1);
pd[36] = -(T_0*EWG_cell_3_side_2);
pd[37] = -(T_0*EWG_cell_3_side_3);
pd[38] = -(T_0*EWG_cell_3_side_4);
pd[39] = -(T_0*EWG_cell_3_side_5);
}

void dres_dExo_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[12] = -(T_0*IWG_cell_0);
pd[13] = -(T_0*IWG_cell_1);
pd[14] = -(T_0*IWG_cell_2);
pd[15] = -(T_0*IWG_cell_3);
pd[16] = T_0*IWG_cell_0*0.166666666667;
pd[17] = T_0*IWG_cell_0*0.166666666667;
pd[18] = T_0*IWG_cell_0*0.166666666667;
pd[19] = T_0*IWG_cell_0*0.166666666667;
pd[20] = T_0*IWG_cell_0*0.166666666667;
pd[21] = T_0*IWG_cell_0*0.166666666667;
pd[22] = T_0*IWG_cell_1*0.166666666667;
pd[23] = T_0*IWG_cell_1*0.166666666667;
pd[24] = T_0*IWG_cell_1*0.166666666667;
pd[25] = T_0*IWG_cell_1*0.166666666667;
pd[26] = T_0*IWG_cell_1*0.166666666667;
pd[27] = T_0*IWG_cell_1*0.166666666667;
pd[28] = T_0*IWG_cell_2*0.166666666667;
pd[29] = T_0*IWG_cell_2*0.166666666667;
pd[30] = T_0*IWG_cell_2*0.166666666667;
pd[31] = T_0*IWG_cell_2*0.166666666667;
pd[32] = T_0*IWG_cell_2*0.166666666667;
pd[33] = T_0*IWG_cell_2*0.166666666667;
pd[34] = T_0*IWG_cell_3*0.166666666667;
pd[35] = T_0*IWG_cell_3*0.166666666667;
pd[36] = T_0*IWG_cell_3*0.166666666667;
pd[37] = T_0*IWG_cell_3*0.166666666667;
pd[38] = T_0*IWG_cell_3*0.166666666667;
pd[39] = T_0*IWG_cell_3*0.166666666667;
}

void dres_dMxfer_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[16] = T_0*(EWG_cell_0_side_3 - EWG_cell_0_side_0);
pd[17] = T_0*(EWG_cell_1_side_4 - EWG_cell_0_side_1);
pd[18] = T_0*(EWG_cell_1_side_5 - EWG_cell_0_side_2);
pd[19] = T_0*(EWG_cell_0_side_0 - EWG_cell_0_side_3);
pd[20] = T_0*(EWG_cell_3_side_1 - EWG_cell_0_side_4);
pd[21] = T_0*(EWG_cell_3_side_2 - EWG_cell_0_side_5);
pd[22] = T_0*(EWG_cell_1_side_3 - EWG_cell_1_side_0);
pd[23] = T_0*(EWG_cell_2_side_4 - EWG_cell_1_side_1);
pd[24] = T_0*(EWG_cell_2_side_5 - EWG_cell_1_side_2);
pd[25] = T_0*(EWG_cell_1_side_0 - EWG_cell_1_side_3);
pd[26] = T_0*(EWG_cell_0_side_1 - EWG_cell_1_side_4);
pd[27] = T_0*(EWG_cell_0_side_2 - EWG_cell_1_side_5);
pd[28] = T_0*(EWG_cell_2_side_3 - EWG_cell_2_side_0);
pd[29] = T_0*(EWG_cell_3_side_4 - EWG_cell_2_side_1);
pd[30] = T_0*(EWG_cell_3_side_5 - EWG_cell_2_side_2);
pd[31] = T_0*(EWG_cell_2_side_0 - EWG_cell_2_side_3);
pd[32] = T_0*(EWG_cell_1_side_1 - EWG_cell_2_side_4);
pd[33] = T_0*(EWG_cell_1_side_2 - EWG_cell_2_side_5);
pd[34] = T_0*(EWG_cell_3_side_3 - EWG_cell_3_side_0);
pd[35] = T_0*(EWG_cell_0_side_4 - EWG_cell_3_side_1);
pd[36] = T_0*(EWG_cell_0_side_5 - EWG_cell_3_side_2);
pd[37] = T_0*(EWG_cell_3_side_0 - EWG_cell_3_side_3);
pd[38] = T_0*(EWG_cell_2_side_1 - EWG_cell_3_side_4);
pd[39] = T_0*(EWG_cell_2_side_2 - EWG_cell_3_side_5);
}

void dres_dLMxfer_WG_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[16] = T_0*(EWG_cell_0_side_5 + EWG_cell_0_side_1 - EWG_cell_0_side_0*2.0);
pd[17] = T_0*(EWG_cell_0_side_0 + EWG_cell_0_side_2 - EWG_cell_0_side_1*2.0);
pd[18] = T_0*(EWG_cell_0_side_1 + EWG_cell_0_side_3 - EWG_cell_0_side_2*2.0);
pd[19] = T_0*(EWG_cell_0_side_2 + EWG_cell_0_side_4 - EWG_cell_0_side_3*2.0);
pd[20] = T_0*(EWG_cell_0_side_3 + EWG_cell_0_side_5 - EWG_cell_0_side_4*2.0);
pd[21] = T_0*(EWG_cell_0_side_4 + EWG_cell_0_side_0 - EWG_cell_0_side_5*2.0);
pd[22] = T_0*(EWG_cell_1_side_5 + EWG_cell_1_side_1 - EWG_cell_1_side_0*2.0);
pd[23] = T_0*(EWG_cell_1_side_0 + EWG_cell_1_side_2 - EWG_cell_1_side_1*2.0);
pd[24] = T_0*(EWG_cell_1_side_1 + EWG_cell_1_side_3 - EWG_cell_1_side_2*2.0);
pd[25] = T_0*(EWG_cell_1_side_2 + EWG_cell_1_side_4 - EWG_cell_1_side_3*2.0);
pd[26] = T_0*(EWG_cell_1_side_3 + EWG_cell_1_side_5 - EWG_cell_1_side_4*2.0);
pd[27] = T_0*(EWG_cell_1_side_4 + EWG_cell_1_side_0 - EWG_cell_1_side_5*2.0);
pd[28] = T_0*(EWG_cell_2_side_5 + EWG_cell_2_side_1 - EWG_cell_2_side_0*2.0);
pd[29] = T_0*(EWG_cell_2_side_0 + EWG_cell_2_side_2 - EWG_cell_2_side_1*2.0);
pd[30] = T_0*(EWG_cell_2_side_1 + EWG_cell_2_side_3 - EWG_cell_2_side_2*2.0);
pd[31] = T_0*(EWG_cell_2_side_2 + EWG_cell_2_side_4 - EWG_cell_2_side_3*2.0);
pd[32] = T_0*(EWG_cell_2_side_3 + EWG_cell_2_side_5 - EWG_cell_2_side_4*2.0);
pd[33] = T_0*(EWG_cell_2_side_4 + EWG_cell_2_side_0 - EWG_cell_2_side_5*2.0);
pd[34] = T_0*(EWG_cell_3_side_5 + EWG_cell_3_side_1 - EWG_cell_3_side_0*2.0);
pd[35] = T_0*(EWG_cell_3_side_0 + EWG_cell_3_side_2 - EWG_cell_3_side_1*2.0);
pd[36] = T_0*(EWG_cell_3_side_1 + EWG_cell_3_side_3 - EWG_cell_3_side_2*2.0);
pd[37] = T_0*(EWG_cell_3_side_2 + EWG_cell_3_side_4 - EWG_cell_3_side_3*2.0);
pd[38] = T_0*(EWG_cell_3_side_3 + EWG_cell_3_side_5 - EWG_cell_3_side_4*2.0);
pd[39] = T_0*(EWG_cell_3_side_4 + EWG_cell_3_side_0 - EWG_cell_3_side_5*2.0);
}

void dres_dLMxfer_PTC_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[44] = T_0*(PTC_cell_0_side_5 + PTC_cell_0_side_1 - PTC_cell_0_side_0*2.0);
pd[45] = T_0*(PTC_cell_0_side_0 + PTC_cell_0_side_2 - PTC_cell_0_side_1*2.0);
pd[46] = T_0*(PTC_cell_0_side_1 + PTC_cell_0_side_3 - PTC_cell_0_side_2*2.0);
pd[47] = T_0*(PTC_cell_0_side_2 + PTC_cell_0_side_4 - PTC_cell_0_side_3*2.0);
pd[48] = T_0*(PTC_cell_0_side_3 + PTC_cell_0_side_5 - PTC_cell_0_side_4*2.0);
pd[49] = T_0*(PTC_cell_0_side_4 + PTC_cell_0_side_0 - PTC_cell_0_side_5*2.0);
pd[50] = T_0*(PTC_cell_1_side_5 + PTC_cell_1_side_1 - PTC_cell_1_side_0*2.0);
pd[51] = T_0*(PTC_cell_1_side_0 + PTC_cell_1_side_2 - PTC_cell_1_side_1*2.0);
pd[52] = T_0*(PTC_cell_1_side_1 + PTC_cell_1_side_3 - PTC_cell_1_side_2*2.0);
pd[53] = T_0*(PTC_cell_1_side_2 + PTC_cell_1_side_4 - PTC_cell_1_side_3*2.0);
pd[54] = T_0*(PTC_cell_1_side_3 + PTC_cell_1_side_5 - PTC_cell_1_side_4*2.0);
pd[55] = T_0*(PTC_cell_1_side_4 + PTC_cell_1_side_0 - PTC_cell_1_side_5*2.0);
pd[56] = T_0*(PTC_cell_2_side_5 + PTC_cell_2_side_1 - PTC_cell_2_side_0*2.0);
pd[57] = T_0*(PTC_cell_2_side_0 + PTC_cell_2_side_2 - PTC_cell_2_side_1*2.0);
pd[58] = T_0*(PTC_cell_2_side_1 + PTC_cell_2_side_3 - PTC_cell_2_side_2*2.0);
pd[59] = T_0*(PTC_cell_2_side_2 + PTC_cell_2_side_4 - PTC_cell_2_side_3*2.0);
pd[60] = T_0*(PTC_cell_2_side_3 + PTC_cell_2_side_5 - PTC_cell_2_side_4*2.0);
pd[61] = T_0*(PTC_cell_2_side_4 + PTC_cell_2_side_0 - PTC_cell_2_side_5*2.0);
pd[62] = T_0*(PTC_cell_3_side_5 + PTC_cell_3_side_1 - PTC_cell_3_side_0*2.0);
pd[63] = T_0*(PTC_cell_3_side_0 + PTC_cell_3_side_2 - PTC_cell_3_side_1*2.0);
pd[64] = T_0*(PTC_cell_3_side_1 + PTC_cell_3_side_3 - PTC_cell_3_side_2*2.0);
pd[65] = T_0*(PTC_cell_3_side_2 + PTC_cell_3_side_4 - PTC_cell_3_side_3*2.0);
pd[66] = T_0*(PTC_cell_3_side_3 + PTC_cell_3_side_5 - PTC_cell_3_side_4*2.0);
pd[67] = T_0*(PTC_cell_3_side_4 + PTC_cell_3_side_0 - PTC_cell_3_side_5*2.0);
}

void dres_dLMxfer_HH_(double *time_ptr, double *dynamicVars, double *yprime, double *constants, double *pd){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

pd[84] = T_0*(HH_cell_0_side_5 + HH_cell_0_side_1 - HH_cell_0_side_0*2.0);
pd[85] = T_0*(HH_cell_0_side_0 + HH_cell_0_side_2 - HH_cell_0_side_1*2.0);
pd[86] = T_0*(HH_cell_0_side_1 + HH_cell_0_side_3 - HH_cell_0_side_2*2.0);
pd[87] = T_0*(HH_cell_0_side_2 + HH_cell_0_side_4 - HH_cell_0_side_3*2.0);
pd[88] = T_0*(HH_cell_0_side_3 + HH_cell_0_side_5 - HH_cell_0_side_4*2.0);
pd[89] = T_0*(HH_cell_0_side_4 + HH_cell_0_side_0 - HH_cell_0_side_5*2.0);
pd[90] = T_0*(HH_cell_1_side_5 + HH_cell_1_side_1 - HH_cell_1_side_0*2.0);
pd[91] = T_0*(HH_cell_1_side_0 + HH_cell_1_side_2 - HH_cell_1_side_1*2.0);
pd[92] = T_0*(HH_cell_1_side_1 + HH_cell_1_side_3 - HH_cell_1_side_2*2.0);
pd[93] = T_0*(HH_cell_1_side_2 + HH_cell_1_side_4 - HH_cell_1_side_3*2.0);
pd[94] = T_0*(HH_cell_1_side_3 + HH_cell_1_side_5 - HH_cell_1_side_4*2.0);
pd[95] = T_0*(HH_cell_1_side_4 + HH_cell_1_side_0 - HH_cell_1_side_5*2.0);
pd[96] = T_0*(HH_cell_2_side_5 + HH_cell_2_side_1 - HH_cell_2_side_0*2.0);
pd[97] = T_0*(HH_cell_2_side_0 + HH_cell_2_side_2 - HH_cell_2_side_1*2.0);
pd[98] = T_0*(HH_cell_2_side_1 + HH_cell_2_side_3 - HH_cell_2_side_2*2.0);
pd[99] = T_0*(HH_cell_2_side_2 + HH_cell_2_side_4 - HH_cell_2_side_3*2.0);
pd[100] = T_0*(HH_cell_2_side_3 + HH_cell_2_side_5 - HH_cell_2_side_4*2.0);
pd[101] = T_0*(HH_cell_2_side_4 + HH_cell_2_side_0 - HH_cell_2_side_5*2.0);
pd[102] = T_0*(HH_cell_3_side_5 + HH_cell_3_side_1 - HH_cell_3_side_0*2.0);
pd[103] = T_0*(HH_cell_3_side_0 + HH_cell_3_side_2 - HH_cell_3_side_1*2.0);
pd[104] = T_0*(HH_cell_3_side_1 + HH_cell_3_side_3 - HH_cell_3_side_2*2.0);
pd[105] = T_0*(HH_cell_3_side_2 + HH_cell_3_side_4 - HH_cell_3_side_3*2.0);
pd[106] = T_0*(HH_cell_3_side_3 + HH_cell_3_side_5 - HH_cell_3_side_4*2.0);
pd[107] = T_0*(HH_cell_3_side_4 + HH_cell_3_side_0 - HH_cell_3_side_5*2.0);
}

void sens_rhs_(double *time_ptr, double *sens_y, double *sens_yp, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar){

res_function_(time_ptr, sens_y, sens_yp, cj_ptr, sens_res, ires_ptr, constants, ipar);

int p_index = (int)constants[58];
double constants_only[58];
int jj;
for (jj = 0; jj < 58; jj++){
constants_only[jj] = constants[jj];}
double *dc_dp = &sens_y[132];
double *dcdot_dp = &sens_yp[132];
double *dres_dp = &sens_res[132];
int ii;
for(ii = 0; ii < 132; ii++){
dres_dp[ii] = 0;}
switch(p_index)
{
case 0 : dres_dK_WGen_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 1 : dres_dK_CNen_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 2 : dres_dK_WGwg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 3 : dres_dK_CIDwg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 4 : dres_dK_CNwg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 5 : dres_dK_CIDptc_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 6 : dres_dK_CNptc_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 7 : dres_dK_Bcid_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 8 : dres_dK_ENcid_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 9 : dres_dK_PTCCID_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 10 : dres_dK_ENhh_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 11 : dres_dK_CNhh_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 12 : dres_dK_PTC_HH_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 13 : dres_dmaxPTC_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 14 : dres_dmaxHH_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 15 : dres_dC_CID_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 16 : dres_dnu_WGen_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 17 : dres_dnu_CNen_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 18 : dres_dnu_WGwg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 19 : dres_dnu_CIDwg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 20 : dres_dnu_CNwg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 21 : dres_dnu_CIDptc_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 22 : dres_dnu_CNptc_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 23 : dres_dnu_Bcid_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 24 : dres_dnu_ENcid_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 25 : dres_dnu_PTCCID_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 26 : dres_dnu_ENhh_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 27 : dres_dnu_CNhh_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 28 : dres_dH_en_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 29 : dres_dH_EN_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 30 : dres_dH_wg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 31 : dres_dH_IWG_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 32 : dres_dH_EWG_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 33 : dres_dH_ptc_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 34 : dres_dH_PTC_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 35 : dres_dH_cid_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 36 : dres_dH_CID_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 37 : dres_dH_CN_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 38 : dres_dH_hh_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 39 : dres_dH_HH_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 40 : dres_dH_PH_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 41 : dres_dalpha_wg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 42 : dres_dbeta_wg_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 43 : dres_dEndo_WG_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 44 : dres_dExo_WG_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 45 : dres_dMxfer_WG_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 46 : dres_dLMxfer_WG_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 47 : dres_dLMxfer_PTC_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
case 48 : dres_dLMxfer_HH_(time_ptr, sens_y, sens_yp, constants_only, dres_dp);
break;
}
double dres_dc[17424] = {0};
dres_dc_function_(time_ptr, sens_y, sens_yp, constants, dres_dc);
int row, col;
for(row = 0; row < 132; row++){
for(col = 0; col < 132; col++){
sens_res[row+132] += dres_dc[row + col*132]*dc_dp[col];}}
double dres_dcdot[17424] = {0};
dres_dcdot_function_(time_ptr, sens_y, sens_yp, constants, dres_dcdot);
for(row = 0; row < 132; row++){
for(col = 0; col < 132; col++){
sens_res[row+132] += dres_dcdot[row + col*132]*dcdot_dp[col];}}
}

void res_function_logdv_(double *time_ptr, double *log_dv, double *log_yp, double *cj_ptr, double *residual, int *ires_ptr, double *constants, int *ipar){
double dynamicVars[132];
double yprime[132];
int ii;
for(ii = 0; ii < 132; ii++){
dynamicVars[ii] = max(exp(log_dv[ii]), DBL_MIN);
yprime[ii] = log_yp[ii] * dynamicVars[ii];}
res_function_(time_ptr, dynamicVars, yprime, cj_ptr, residual, ires_ptr, constants, ipar);
}

void root_func_logdv_(int *neq_ptr, double *time_ptr, double *log_dv, double *log_yp, int *nrt_ptr, double *root_devs, double *constants, int *ipar){
double dynamicVars[132];
double yprime[132];
int ii;
for(ii = 0; ii < 132; ii++){
dynamicVars[ii] = max(exp(log_dv[ii]), DBL_MIN);
yprime[ii] = log_yp[ii] * dynamicVars[ii];}
root_func_(neq_ptr, time_ptr, dynamicVars, yprime, nrt_ptr, root_devs, constants, ipar);
}

void sens_rhs_logdv_(double *time_ptr, double *sens_y_log, double *sens_yp_log, double *cj_ptr, double *sens_res, int *ires_ptr, double *constants, int *ipar){
double sens_y[264];
double sens_yp[264];
int ii;
for(ii = 0; ii < 132; ii++){
sens_y[ii] = max(exp(sens_y_log[ii]), DBL_MIN);
sens_yp[ii] = sens_yp_log[ii] * sens_y[ii];}
for(ii = 132; ii < 264; ii++){
sens_y[ii] = sens_y_log[ii];
sens_yp[ii] = sens_yp_log[ii];}
sens_rhs_(time_ptr, sens_y, sens_yp, cj_ptr, sens_res, ires_ptr, constants, ipar);
}

void integrate_stochastic_tidbit_(unsigned long* seed_ptr, int* reseed, double* time_ptr, int* dv, double* cv, double* rmsd_ptr, double* stop_time_ptr, double* trajectory) {
return;}

void root_func_(int *neq_ptr, double *time_ptr, double *dynamicVars, double *yprime, int *nrt_ptr, double *root_devs, double *constants, int *ipar){
double time = *time_ptr;

double cell_0 = constants[0];
double cell_1 = constants[1];
double cell_2 = constants[2];
double cell_3 = constants[3];
double B_cell_0 = constants[4];
double B_cell_1 = constants[5];
double B_cell_2 = constants[6];
double B_cell_3 = constants[7];
double K_WGen = constants[8];
double K_CNen = constants[9];
double K_WGwg = constants[10];
double K_CIDwg = constants[11];
double K_CNwg = constants[12];
double K_CIDptc = constants[13];
double K_CNptc = constants[14];
double K_Bcid = constants[15];
double K_ENcid = constants[16];
double K_PTCCID = constants[17];
double K_ENhh = constants[18];
double K_CNhh = constants[19];
double K_PTC_HH = constants[20];
double maxPTC = constants[21];
double maxHH = constants[22];
double C_CID = constants[23];
double nu_WGen = constants[24];
double nu_CNen = constants[25];
double nu_WGwg = constants[26];
double nu_CIDwg = constants[27];
double nu_CNwg = constants[28];
double nu_CIDptc = constants[29];
double nu_CNptc = constants[30];
double nu_Bcid = constants[31];
double nu_ENcid = constants[32];
double nu_PTCCID = constants[33];
double nu_ENhh = constants[34];
double nu_CNhh = constants[35];
double H_en = constants[36];
double H_EN = constants[37];
double H_wg = constants[38];
double H_IWG = constants[39];
double H_EWG = constants[40];
double H_ptc = constants[41];
double H_PTC = constants[42];
double H_cid = constants[43];
double H_CID = constants[44];
double H_CN = constants[45];
double H_hh = constants[46];
double H_HH = constants[47];
double H_PH = constants[48];
double alpha_wg = constants[49];
double beta_wg = constants[50];
double Endo_WG = constants[51];
double Exo_WG = constants[52];
double Mxfer_WG = constants[53];
double LMxfer_WG = constants[54];
double LMxfer_PTC = constants[55];
double LMxfer_HH = constants[56];
double T_0 = constants[57];

double en_cell_0 = dynamicVars[0];
double en_cell_1 = dynamicVars[1];
double en_cell_2 = dynamicVars[2];
double en_cell_3 = dynamicVars[3];
double EN_cell_0 = dynamicVars[4];
double EN_cell_1 = dynamicVars[5];
double EN_cell_2 = dynamicVars[6];
double EN_cell_3 = dynamicVars[7];
double wg_cell_0 = dynamicVars[8];
double wg_cell_1 = dynamicVars[9];
double wg_cell_2 = dynamicVars[10];
double wg_cell_3 = dynamicVars[11];
double IWG_cell_0 = dynamicVars[12];
double IWG_cell_1 = dynamicVars[13];
double IWG_cell_2 = dynamicVars[14];
double IWG_cell_3 = dynamicVars[15];
double EWG_cell_0_side_0 = dynamicVars[16];
double EWG_cell_0_side_1 = dynamicVars[17];
double EWG_cell_0_side_2 = dynamicVars[18];
double EWG_cell_0_side_3 = dynamicVars[19];
double EWG_cell_0_side_4 = dynamicVars[20];
double EWG_cell_0_side_5 = dynamicVars[21];
double EWG_cell_1_side_0 = dynamicVars[22];
double EWG_cell_1_side_1 = dynamicVars[23];
double EWG_cell_1_side_2 = dynamicVars[24];
double EWG_cell_1_side_3 = dynamicVars[25];
double EWG_cell_1_side_4 = dynamicVars[26];
double EWG_cell_1_side_5 = dynamicVars[27];
double EWG_cell_2_side_0 = dynamicVars[28];
double EWG_cell_2_side_1 = dynamicVars[29];
double EWG_cell_2_side_2 = dynamicVars[30];
double EWG_cell_2_side_3 = dynamicVars[31];
double EWG_cell_2_side_4 = dynamicVars[32];
double EWG_cell_2_side_5 = dynamicVars[33];
double EWG_cell_3_side_0 = dynamicVars[34];
double EWG_cell_3_side_1 = dynamicVars[35];
double EWG_cell_3_side_2 = dynamicVars[36];
double EWG_cell_3_side_3 = dynamicVars[37];
double EWG_cell_3_side_4 = dynamicVars[38];
double EWG_cell_3_side_5 = dynamicVars[39];
double ptc_cell_0 = dynamicVars[40];
double ptc_cell_1 = dynamicVars[41];
double ptc_cell_2 = dynamicVars[42];
double ptc_cell_3 = dynamicVars[43];
double PTC_cell_0_side_0 = dynamicVars[44];
double PTC_cell_0_side_1 = dynamicVars[45];
double PTC_cell_0_side_2 = dynamicVars[46];
double PTC_cell_0_side_3 = dynamicVars[47];
double PTC_cell_0_side_4 = dynamicVars[48];
double PTC_cell_0_side_5 = dynamicVars[49];
double PTC_cell_1_side_0 = dynamicVars[50];
double PTC_cell_1_side_1 = dynamicVars[51];
double PTC_cell_1_side_2 = dynamicVars[52];
double PTC_cell_1_side_3 = dynamicVars[53];
double PTC_cell_1_side_4 = dynamicVars[54];
double PTC_cell_1_side_5 = dynamicVars[55];
double PTC_cell_2_side_0 = dynamicVars[56];
double PTC_cell_2_side_1 = dynamicVars[57];
double PTC_cell_2_side_2 = dynamicVars[58];
double PTC_cell_2_side_3 = dynamicVars[59];
double PTC_cell_2_side_4 = dynamicVars[60];
double PTC_cell_2_side_5 = dynamicVars[61];
double PTC_cell_3_side_0 = dynamicVars[62];
double PTC_cell_3_side_1 = dynamicVars[63];
double PTC_cell_3_side_2 = dynamicVars[64];
double PTC_cell_3_side_3 = dynamicVars[65];
double PTC_cell_3_side_4 = dynamicVars[66];
double PTC_cell_3_side_5 = dynamicVars[67];
double cid_cell_0 = dynamicVars[68];
double cid_cell_1 = dynamicVars[69];
double cid_cell_2 = dynamicVars[70];
double cid_cell_3 = dynamicVars[71];
double CID_cell_0 = dynamicVars[72];
double CID_cell_1 = dynamicVars[73];
double CID_cell_2 = dynamicVars[74];
double CID_cell_3 = dynamicVars[75];
double CN_cell_0 = dynamicVars[76];
double CN_cell_1 = dynamicVars[77];
double CN_cell_2 = dynamicVars[78];
double CN_cell_3 = dynamicVars[79];
double hh_cell_0 = dynamicVars[80];
double hh_cell_1 = dynamicVars[81];
double hh_cell_2 = dynamicVars[82];
double hh_cell_3 = dynamicVars[83];
double HH_cell_0_side_0 = dynamicVars[84];
double HH_cell_0_side_1 = dynamicVars[85];
double HH_cell_0_side_2 = dynamicVars[86];
double HH_cell_0_side_3 = dynamicVars[87];
double HH_cell_0_side_4 = dynamicVars[88];
double HH_cell_0_side_5 = dynamicVars[89];
double HH_cell_1_side_0 = dynamicVars[90];
double HH_cell_1_side_1 = dynamicVars[91];
double HH_cell_1_side_2 = dynamicVars[92];
double HH_cell_1_side_3 = dynamicVars[93];
double HH_cell_1_side_4 = dynamicVars[94];
double HH_cell_1_side_5 = dynamicVars[95];
double HH_cell_2_side_0 = dynamicVars[96];
double HH_cell_2_side_1 = dynamicVars[97];
double HH_cell_2_side_2 = dynamicVars[98];
double HH_cell_2_side_3 = dynamicVars[99];
double HH_cell_2_side_4 = dynamicVars[100];
double HH_cell_2_side_5 = dynamicVars[101];
double HH_cell_3_side_0 = dynamicVars[102];
double HH_cell_3_side_1 = dynamicVars[103];
double HH_cell_3_side_2 = dynamicVars[104];
double HH_cell_3_side_3 = dynamicVars[105];
double HH_cell_3_side_4 = dynamicVars[106];
double HH_cell_3_side_5 = dynamicVars[107];
double PH_cell_0_side_0 = dynamicVars[108];
double PH_cell_0_side_1 = dynamicVars[109];
double PH_cell_0_side_2 = dynamicVars[110];
double PH_cell_0_side_3 = dynamicVars[111];
double PH_cell_0_side_4 = dynamicVars[112];
double PH_cell_0_side_5 = dynamicVars[113];
double PH_cell_1_side_0 = dynamicVars[114];
double PH_cell_1_side_1 = dynamicVars[115];
double PH_cell_1_side_2 = dynamicVars[116];
double PH_cell_1_side_3 = dynamicVars[117];
double PH_cell_1_side_4 = dynamicVars[118];
double PH_cell_1_side_5 = dynamicVars[119];
double PH_cell_2_side_0 = dynamicVars[120];
double PH_cell_2_side_1 = dynamicVars[121];
double PH_cell_2_side_2 = dynamicVars[122];
double PH_cell_2_side_3 = dynamicVars[123];
double PH_cell_2_side_4 = dynamicVars[124];
double PH_cell_2_side_5 = dynamicVars[125];
double PH_cell_3_side_0 = dynamicVars[126];
double PH_cell_3_side_1 = dynamicVars[127];
double PH_cell_3_side_2 = dynamicVars[128];
double PH_cell_3_side_3 = dynamicVars[129];
double PH_cell_3_side_4 = dynamicVars[130];
double PH_cell_3_side_5 = dynamicVars[131];

double EWG_tot_pres_cell_0 = EWG_cell_0_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5 + EWG_cell_0_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2;
double EWG_tot_cell_0 = EWG_cell_0_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2 + EWG_cell_0_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5;
double PTC_tot_cell_0 = PTC_cell_0_side_0 + PTC_cell_0_side_1 + PTC_cell_0_side_2 + PTC_cell_0_side_3 + PTC_cell_0_side_4 + PTC_cell_0_side_5;
double EWG_tot_pres_cell_1 = EWG_cell_1_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5 + EWG_cell_1_side_0 + EWG_cell_0_side_1 + EWG_cell_0_side_2;
double EWG_tot_cell_1 = EWG_cell_1_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2 + EWG_cell_1_side_3 + EWG_cell_1_side_4 + EWG_cell_1_side_5;
double PTC_tot_cell_1 = PTC_cell_1_side_0 + PTC_cell_1_side_1 + PTC_cell_1_side_2 + PTC_cell_1_side_3 + PTC_cell_1_side_4 + PTC_cell_1_side_5;
double EWG_tot_pres_cell_2 = EWG_cell_2_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5 + EWG_cell_2_side_0 + EWG_cell_1_side_1 + EWG_cell_1_side_2;
double EWG_tot_cell_2 = EWG_cell_2_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2 + EWG_cell_2_side_3 + EWG_cell_2_side_4 + EWG_cell_2_side_5;
double PTC_tot_cell_2 = PTC_cell_2_side_0 + PTC_cell_2_side_1 + PTC_cell_2_side_2 + PTC_cell_2_side_3 + PTC_cell_2_side_4 + PTC_cell_2_side_5;
double EWG_tot_pres_cell_3 = EWG_cell_3_side_3 + EWG_cell_0_side_4 + EWG_cell_0_side_5 + EWG_cell_3_side_0 + EWG_cell_2_side_1 + EWG_cell_2_side_2;
double EWG_tot_cell_3 = EWG_cell_3_side_0 + EWG_cell_3_side_1 + EWG_cell_3_side_2 + EWG_cell_3_side_3 + EWG_cell_3_side_4 + EWG_cell_3_side_5;
double PTC_tot_cell_3 = PTC_cell_3_side_0 + PTC_cell_3_side_1 + PTC_cell_3_side_2 + PTC_cell_3_side_3 + PTC_cell_3_side_4 + PTC_cell_3_side_5;

}
